/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarShelf;
import org.vcs.bazaar.client.IBazaarShelf;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLShelveListParser
extends XMLParser {
    private static final String SHELVES = "shelves";
    private static final String SHELF = "shelf";
    private static final String ID = "id";
    private static final String MESSAGE = "message";

    public static List<IBazaarShelf> parse(String xml) throws BazaarClientException {
        KXmlParser parser = new KXmlParser();
        try {
            parser.setInput((Reader)new StringReader(xml));
            return new XMLShelveListParser().parse(parser);
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
    }

    public List<IBazaarShelf> parse(KXmlParser aParser) throws BazaarClientException {
        ArrayList<IBazaarShelf> shelves = new ArrayList<IBazaarShelf>();
        this.parser = aParser;
        try {
            this.parser.nextTag();
            this.parser.require(2, null, SHELVES);
            int eventType = this.parser.getEventType();
            while (!(eventType == 1 || eventType == 3 && SHELVES.equals(this.parser.getName()))) {
                IBazaarShelf shelf;
                if (eventType == 2 && SHELF.equals(this.parser.getName()) && (shelf = this.parseShelf()) != null) {
                    shelves.add(shelf);
                }
                eventType = this.parser.next();
            }
            return shelves;
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
    }

    private IBazaarShelf parseShelf() throws XmlPullParserException, IOException {
        String id = null;
        String message = null;
        int eventType = this.parser.next();
        while (!(eventType == 1 || eventType == 3 && SHELF.equals(this.parser.getName()))) {
            if (eventType == 2 && ID.equals(this.parser.getName())) {
                id = this.parser.nextText();
            } else if (eventType == 2 && MESSAGE.equals(this.parser.getName())) {
                message = this.parser.nextText();
            }
            eventType = this.parser.next();
        }
        return new BazaarShelf(id, message);
    }
}

