/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.commandline.CommandLineStatus;
import org.vcs.bazaar.client.commandline.parser.XMLLogParser;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StringUtil;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStatusParser
extends XMLParser {
    private static final Log LOG = LogFactory.getLog(XMLStatusParser.class);
    private final List<IBazaarStatus> statuses = new ArrayList<IBazaarStatus>(0);
    private List<IBazaarLogMessage> pendingMerges = null;
    private Set<IBazaarStatus> statusSet = null;
    private static final String ADDED = "added";
    private static final String REMOVED = "removed";
    private static final String RENAMED = "renamed";
    private static final String MODIFIED = "modified";
    private static final String KIND_CHANGED = "kind-changed";
    private static final String UNKNOWN = "unknown";
    private static final String FILE = "file";
    private static final String DIR = "directory";
    private static final String OLDKIND = "oldkind";
    private static final String NEWKIND = "newkind";
    private static final String OLDPATH = "oldpath";
    private static final String FID = "fid";
    private static final String SUFFIX = "suffix";
    private static final String META_MODIFIED = "meta_modified";
    private static final String STATUS = "status";
    private static final String BRANCH_ROOT = "workingtree_root";
    private static final String CONFLICTS = "conflicts";
    private static final String CONFLICT = "conflict";
    private static final String PENDING_MERGES = "pending_merges";

    public void parse(String xml) throws BazaarClientException {
        this.parser = new KXmlParser();
        try {
            this.parser.setInput((Reader)new StringReader(xml));
            int eventType = this.parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && this.isGroup(this.parser.getName())) {
                    this.parseGroup();
                } else if (eventType == 2 && STATUS.equals(this.parser.getName())) {
                    this.workDir = new File(this.parser.getAttributeValue(null, BRANCH_ROOT));
                } else if (eventType == 2 && PENDING_MERGES.equals(this.parser.getName())) {
                    this.parsePendingMerges();
                }
                eventType = this.parser.next();
            }
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
        this.statusSet = this.orderAndCleanup();
    }

    public Set<IBazaarStatus> getStatusSet() {
        return this.statusSet;
    }

    public List<IBazaarLogMessage> getPendingMerges() {
        if (this.pendingMerges == null) {
            this.pendingMerges = Collections.emptyList();
        }
        return this.pendingMerges;
    }

    private void parsePendingMerges() throws BazaarClientException {
        LOG.debug((Object)"Parsing pending merges");
        try {
            this.pendingMerges = new XMLLogParser().parse(this.parser);
        }
        catch (Exception e) {
            LOG.error((Object)"unexpected error while parsing pending merges", (Throwable)e);
            this.pendingMerges = null;
        }
        if (this.pendingMerges == null) {
            this.pendingMerges = new ArrayList<IBazaarLogMessage>(0);
        }
    }

    private boolean isGroup(String name) {
        return name.equals(ADDED) || name.equals(REMOVED) || name.equals(RENAMED) || name.equals(MODIFIED) || name.equals(KIND_CHANGED) || name.equals(UNKNOWN) || name.equals(CONFLICTS);
    }

    private void parseGroup() throws XmlPullParserException, IOException {
        String group = this.parser.getName();
        LOG.debug((Object)("Parsing status group: " + group));
        int eventType = this.parser.next();
        while (eventType != 1) {
            String path;
            if (eventType == 2 && CONFLICT.equals(this.parser.getName())) {
                path = StringUtil.nullSafeTrim(this.parser.nextText());
                if (path.endsWith(".BASE") || path.endsWith(".THIS") || path.endsWith(".OTHER")) {
                    eventType = this.parser.next();
                    continue;
                }
                CommandLineStatus status = new CommandLineStatus(XMLStatusParser.getStatusKind(group), XMLStatusParser.getAsFile(path), false, null, null, null, this.workDir);
                this.statuses.add(status);
            } else if (eventType == 2 && (this.parser.getName().equals(FILE) || this.parser.getName().equals(DIR))) {
                String oldKind = null;
                String newKind = null;
                String prevPath = null;
                path = null;
                boolean metaModified = false;
                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                    if (this.parser.getAttributeName(i).equals(OLDKIND)) {
                        oldKind = StringUtil.nullSafeTrim(this.parser.getAttributeValue(i));
                        continue;
                    }
                    if (this.parser.getAttributeName(i).equals(NEWKIND)) {
                        newKind = StringUtil.nullSafeTrim(this.parser.getAttributeValue(i));
                        continue;
                    }
                    if (this.parser.getAttributeName(i).equals(OLDPATH)) {
                        prevPath = StringUtil.nullSafeTrim(this.parser.getAttributeValue(i));
                        continue;
                    }
                    if (this.parser.getAttributeName(i).equals(FID) || this.parser.getAttributeName(i).equals(SUFFIX) || !this.parser.getAttributeName(i).equals(META_MODIFIED)) continue;
                    metaModified = Boolean.parseBoolean(this.parser.getAttributeValue(i));
                }
                path = StringUtil.nullSafeTrim(this.parser.nextText());
                if (path.endsWith(".BASE") || path.endsWith(".THIS") || path.endsWith(".OTHER")) {
                    eventType = this.parser.next();
                    continue;
                }
                CommandLineStatus status = new CommandLineStatus(XMLStatusParser.getStatusKind(group), XMLStatusParser.getAsFile(path), this.parser.getName().equals(DIR), XMLStatusParser.getAsFile(prevPath), newKind, oldKind, this.workDir);
                if (metaModified) {
                    status.merge(BazaarStatusKind.X_BIT_CHANGED);
                }
                this.statuses.add(status);
            } else if (eventType == 3 && group.equals(this.parser.getName())) {
                return;
            }
            eventType = this.parser.next();
        }
    }

    private static BazaarStatusKind getStatusKind(String group) {
        if (group.equals(ADDED)) {
            return BazaarStatusKind.CREATED;
        }
        if (group.equals(REMOVED)) {
            return BazaarStatusKind.DELETED;
        }
        if (group.equals(RENAMED)) {
            return BazaarStatusKind.RENAMED;
        }
        if (group.equals(MODIFIED)) {
            return BazaarStatusKind.MODIFIED;
        }
        if (group.equals(KIND_CHANGED)) {
            return BazaarStatusKind.KIND_CHANGED;
        }
        if (group.equals(UNKNOWN)) {
            return BazaarStatusKind.UNKNOWN;
        }
        if (group.equals(CONFLICTS)) {
            return BazaarStatusKind.HAS_CONFLICTS;
        }
        return null;
    }

    private static File getAsFile(String relativePathTofile) {
        if (relativePathTofile != null && !"".equals(relativePathTofile)) {
            return new File(relativePathTofile);
        }
        return null;
    }

    private Set<IBazaarStatus> orderAndCleanup() {
        HashMap<String, List<IBazaarStatus>> map = new HashMap<String, List<IBazaarStatus>>();
        for (IBazaarStatus status : this.statuses) {
            ArrayList<IBazaarStatus> list = (ArrayList<IBazaarStatus>)map.get(status.getPath());
            if (list == null) {
                list = new ArrayList<IBazaarStatus>();
                map.put(status.getPath(), list);
            }
            list.add(status);
        }
        return XMLStatusParser.unifyStatuses(map);
    }

    private static Set<IBazaarStatus> unifyStatuses(Map<String, List<IBazaarStatus>> map) {
        Set<String> keySet = map.keySet();
        HashSet<IBazaarStatus> set = new HashSet<IBazaarStatus>(keySet.size());
        for (String key : keySet) {
            CommandLineStatus keeped = null;
            for (IBazaarStatus status : map.get(key)) {
                if (keeped == null) {
                    keeped = (CommandLineStatus)status;
                    continue;
                }
                keeped.merge(status);
            }
            set.add(keeped);
        }
        return set;
    }

    public List<IBazaarStatus> parseForLog(KXmlParser logParser, String endTag) throws XmlPullParserException, IOException {
        this.statuses.clear();
        this.parser = logParser;
        int eventType = this.parser.next();
        while (!endTag.equals(this.parser.getName()) && eventType != 3) {
            if (eventType == 2 && this.isGroup(this.parser.getName())) {
                this.parseGroup();
            }
            eventType = this.parser.next();
        }
        Set<IBazaarStatus> mergedSet = this.orderAndCleanup();
        return Arrays.asList(mergedSet.toArray(new IBazaarStatus[mergedSet.size()]));
    }
}

