/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.BazaarVersion;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StringUtil;
import org.xmlpull.v1.XmlPullParserException;

public class XMLVersionParser
extends XMLParser {
    private static final String BAZAAR = "bazaar";
    private static final String VERSION = "version";
    private static final String BZRLIB = "bzrlib";
    private static final String CONFIGURATION = "configuration";
    private static final String LOG_FILE = "log_file";
    private static final String COPYRIGHT = "copyright";

    public static BazaarVersion parse(String xml) throws BazaarClientException {
        KXmlParser parser = new KXmlParser();
        String version = null;
        String bzrlib = null;
        String configuration = null;
        String logFile = null;
        String copyright = null;
        try {
            parser.setInput((Reader)new StringReader(xml));
            parser.nextTag();
            parser.require(2, null, VERSION);
            parser.nextTag();
            parser.require(2, null, BAZAAR);
            int eventType = parser.getEventType();
            while (eventType != 1 || eventType == 3 && BAZAAR.equals(parser.getName())) {
                if (eventType == 2 && VERSION.equals(parser.getName())) {
                    version = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == 2 && BZRLIB.equals(parser.getName())) {
                    bzrlib = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == 2 && CONFIGURATION.equals(parser.getName())) {
                    configuration = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == 2 && LOG_FILE.equals(parser.getName())) {
                    logFile = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == 2 && COPYRIGHT.equals(parser.getName())) {
                    copyright = StringUtil.nullSafeTrim(parser.nextText());
                } else if (eventType == 3 && BAZAAR.equals(parser.getName())) break;
                eventType = parser.next();
            }
            return new BazaarVersion(version, bzrlib, configuration, logFile, copyright);
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
    }
}

