/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.IDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Delta
implements IDelta {
    private final List<IBazaarLogMessage> logs;
    private List<IBazaarStatus> affectedFiles;

    public Delta(IBazaarLogMessage[] logs) {
        this.logs = Arrays.asList(logs);
    }

    public Delta(List<IBazaarLogMessage> logs) {
        this.logs = logs;
    }

    @Override
    public List<IBazaarStatus> getAffectedFiles() {
        if (this.affectedFiles == null) {
            HashSet<IBazaarStatus> all = new HashSet<IBazaarStatus>(this.logs.size());
            for (IBazaarLogMessage log : this.logs) {
                all.addAll(log.getAffectedFiles(true));
            }
            this.affectedFiles = new ArrayList<IBazaarStatus>(all.size());
            this.affectedFiles.addAll(all);
        }
        return this.affectedFiles;
    }

    @Override
    public List<IBazaarLogMessage> getLogs() {
        return this.logs;
    }
}

