/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.utils;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public class StringUtil {
    private static Pattern badchars = Pattern.compile("[^a-zA-Z0-9.,:/\\\\_~-]");
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public static URI getAbsoluteURI(File file) {
        URI proposed = file.toURI();
        return StringUtil.getAbsoluteURI(proposed);
    }

    private static void urlEncodeBuffer(char[] convertionBuffer, int bufferLength, StringBuffer result) throws UnsupportedEncodingException {
        String toConvert = new String(convertionBuffer, 0, bufferLength);
        String encoded = URLEncoder.encode(toConvert, "UTF-8");
        result.append(encoded);
    }

    public static String urlEncode(String url) throws UnsupportedEncodingException {
        char[] convertionBuffer = new char[url.length()];
        StringBuffer result = new StringBuffer();
        int bufferLength = 0;
        for (char ch : url.toCharArray()) {
            if (ch > '\u007f') {
                convertionBuffer[bufferLength++] = ch;
                continue;
            }
            if (bufferLength > 0) {
                StringUtil.urlEncodeBuffer(convertionBuffer, bufferLength, result);
                bufferLength = 0;
            }
            result.append(ch);
        }
        if (bufferLength > 0) {
            StringUtil.urlEncodeBuffer(convertionBuffer, bufferLength, result);
        }
        return result.toString();
    }

    public static URI getAbsoluteURI(URI uri) {
        URI proposed = uri;
        String schemeSpecificPart = StringUtil.makeDriveLetterLowerCase(proposed.getRawSchemeSpecificPart());
        if (proposed.getScheme() == null) {
            return proposed;
        }
        StringBuilder sb = new StringBuilder(":");
        for (int i = 2; i >= 0; --i) {
            if (i == 2 && !"file".equals(proposed.getScheme())) continue;
            if (schemeSpecificPart.length() <= 2 && i == 2) {
                sb.append("/");
                continue;
            }
            if (schemeSpecificPart.charAt(i) == '/') continue;
            sb.append("/");
        }
        try {
            schemeSpecificPart = StringUtil.urlEncode(schemeSpecificPart);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        proposed = URI.create(proposed.getScheme() + sb.toString() + schemeSpecificPart);
        return proposed;
    }

    private static String makeDriveLetterLowerCase(String str) {
        String result = str;
        int colonIndex = str.indexOf(58);
        if (colonIndex > 0) {
            StringBuilder sb = new StringBuilder(str.substring(0, colonIndex - 1));
            sb.append(Character.toLowerCase(str.charAt(colonIndex - 1)));
            sb.append(str.substring(colonIndex));
            result = sb.toString();
        }
        return result;
    }

    public static String shellQuote(String part) {
        if (part != null && badchars.matcher(part).find()) {
            return "\"" + part + "\"";
        }
        return part;
    }

    public static synchronized Date parseDate(String date) throws ParseException {
        return DATE_FORMAT.parse(date);
    }

    public static synchronized Date parseLogDate(String date) throws ParseException {
        return DATE_FORMAT.parse(date.substring(4).trim());
    }

    public static String nullSafeTrim(String aString) {
        if (aString == null) {
            return null;
        }
        return aString.trim();
    }

    public static String encodeURI(String s) throws UnsupportedEncodingException {
        return StringUtil.urlEncode(s.replaceAll("\\\\", "%5C").replaceAll(" ", "%20"));
    }
}

