/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.xmlrpc.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.xmlrpc.BzrXmlRpcError;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLErrorParser
extends XMLParser {
    private static final Log LOG = LogFactory.getLog(XMLErrorParser.class);
    private static final String ERROR = "error";
    private static final String CLASS = "class";
    private static final String DICT = "dict";
    private static final String DICT_KEY = "key";
    private static final String DICT_VALUE = "value";
    private static final String MESSAGE = "message";

    public XMLErrorParser() {
        this.parser = new KXmlParser();
    }

    public IBzrError parse(String xml) {
        try {
            this.parser.setInput((Reader)new StringReader(xml));
            int eventType = this.parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2 && ERROR.equals(this.parser.getName())) {
                    return this.parseError();
                }
                eventType = this.parser.next();
            }
        }
        catch (XmlPullParserException e) {
            LOG.error((Object)"Trouble while parsing error", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"IO trouble while parsing error", (Throwable)e);
        }
        return new BzrXmlRpcError(Collections.EMPTY_MAP, xml, "unknown");
    }

    private IBzrError parseError() throws XmlPullParserException, IOException {
        String type = null;
        String message = null;
        Map<String, String> dict = null;
        int eventType = this.parser.getEventType();
        do {
            switch (eventType) {
                case 2: {
                    if (CLASS.equals(this.parser.getName())) {
                        type = this.parser.nextText();
                    }
                    if (MESSAGE.equals(this.parser.getName())) {
                        message = this.parser.nextText();
                    }
                    if (!DICT.equals(this.parser.getName())) break;
                    dict = this.parseDict();
                }
            }
        } while (!this.isEndTag(eventType = this.parser.next()) || !ERROR.equals(this.parser.getName()));
        return new BzrXmlRpcError(dict, message, type);
    }

    private Map<String, String> parseDict() throws XmlPullParserException, IOException {
        int eventType = this.parser.nextTag();
        HashMap<String, String> dict = new HashMap<String, String>(0);
        while (!this.isEndTag(eventType) || !DICT.equals(this.parser.getName())) {
            String key = null;
            String value = null;
            this.parser.require(2, null, DICT_KEY);
            key = this.parser.nextText();
            eventType = this.parser.nextTag();
            this.parser.require(2, null, DICT_VALUE);
            value = this.parser.nextText();
            eventType = this.parser.nextTag();
            dict.put(key, value);
        }
        return dict;
    }
}

