/**
 * LICENSE + COPYRIGHT
 */
package org.vcs.bazaar.client;

import org.vcs.bazaar.client.BazaarRevision.Prefix;

/**
 * @author Piotr Piastucki
 */
public class BazaarTag implements IBazaarTag {

	private static final long serialVersionUID = -2201792402752147449L;
	private final String name;
	private final String revno;
	
	public BazaarTag(String name, String revno) {
		this.name = name;
		this.revno = revno;
			
	}
	
	public String getName() {
		return name;
	}

	public BazaarRevision getRevision() {
		return revno != null ? BazaarRevision.getRevision(Prefix.REVNO, revno) : null;
	}

}
