/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.internal.CommandWithProgressListener;
import org.vcs.bazaar.client.commandline.syntax.ICheckoutOptions;
import org.vcs.bazaar.client.core.BranchLocation;

/**
 * @author Guillermo Gonzalez
 *
 */
public class CheckOut extends CommandWithProgressListener implements ICheckoutOptions {

	private final BranchLocation remoteBranch;

	private final File localBranch;

	/**
	 * @param fromLocation
	 * @param toLocation
	 */
	public CheckOut(BranchLocation fromLocation, File localBranch) {
		this.remoteBranch = fromLocation;
		this.localBranch = localBranch;
	}


	@Override
	public String getCommand() {
		return COMMAND;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.commands.Command#getArguments()
	 */
	@Override
	protected List<String> getArguments() {
		String fromLocation = this.remoteBranch.toString();
		String toLocation = this.localBranch.getPath();
		return getArguments(fromLocation, toLocation);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.core.model.ICommand#getEstimatedWork()
	 */
	@Override
	public int getEstimatedWork() {
		// TODO: search info about this value, and how can be defined
		return 100;
	}

}
