/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.syntax.IIgnoreOptions;

/**
 * @author Guillermo Gonzalez
 *
 */
public class Ignore extends SingleFileCommand implements IIgnoreOptions {

	final private String pattern;

	/**
	 * @param File
	 *            file - file in the branch or the branch root
	 * @param pattern
	 */
	public Ignore(final File workDir, final String pattern) {
		super(workDir);
		this.pattern = pattern;
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.commandline.internal.Command#getArguments()
	 */
	@Override
	protected List<String> getArguments() {
		return getArguments(pattern);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see org.vcs.bazaar.client.commandline.internal.Command#getCommand()
	 */
	@Override
	public String getCommand() {
		return COMMAND;
	}

}
