/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.util.List;

import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.internal.Command;
import org.vcs.bazaar.client.commandline.syntax.IUnShelveOptions;

/**
 * @author Piotr Piastucki
 */
public class UnShelve extends Command implements IUnShelveOptions {

	private String shelfId;

	public UnShelve(File workDir, String shelfId) {
		super(workDir);
		this.shelfId = shelfId;
	}

	@Override
	public String getCommand() {
		return COMMAND;
	}

	@Override
	protected List<String> getArguments() throws CommandLineException {
		return getArguments(shelfId);
	}

}
