package org.vcs.bazaar.client.commandline.parser;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;

public abstract class XMLParser {

	protected KXmlParser parser;

	protected File workDir;

	public XMLParser() {
		super();
	}

	public static String getDeclaredEncoding(String xml) {
	    if (xml == null)
	        return null;
        if (!xml.trim().startsWith("<?xml"))
            return null;
	    Pattern pattern = Pattern.compile("<\\?xml[^>]*encoding=[\"']([^>]+)[\"'][^>]*\\?>.*");
	    Matcher matcher = pattern.matcher(xml);
	    return matcher.find()? matcher.group(1) : null;
	}

	protected boolean isEndTag(int eventType) {
		return XmlPullParser.END_TAG == eventType;
	}

}