/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.syntax;

import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;

/**
 * @author Guillermo Gonzalez
 *
 */
public interface ICatRevisionOptions {

	public final static String COMMAND = "cat-revision"; //$NON-NLS-N$

	/**
	 * See "help revisionspec" for details.
	 */
	public static final KeywordOption REVISION = new KeywordOption("--revision", "ARG"); //$NON-NLS-N$

	/**
	 * Display more information.
	 */
	public static final Option VERBOSE = new Option("--verbose"); //$NON-NLS-N$

	/**
	 * Only display errors and warnings.
	 */
	public static final Option QUIET = new Option("--quiet"); //$NON-NLS-N$

	public final static String HELP = "Write out metadata for a revision.\\n\\nThe revision to print can either be specified by a specific\\nrevision identifier, or you can use --revision."; //$NON-NLS-N$
}
