/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.syntax;

import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;

/**
 * @author Piotr Piastucki
 */
public interface IRebaseContinueOptions {

	public final static String COMMAND = "rebase-continue"; //$NON-NLS-N$

	/**
	 * Display more information.
	 */
	public static final Option VERBOSE = new Option("--verbose"); //$NON-NLS-N$

	/**
	 * Only display errors and warnings.
	 */
	public static final Option QUIET = new Option("--quiet"); //$NON-NLS-N$

	/**
	 * Branch to merge into, rather than the one containing the working
	 * directory.
	 */
	public static final KeywordOption DIRECTORY = new KeywordOption("--directory", "ARG"); //$NON-NLS-N$

	/**
	 * Select a particular merge algorithm.
	 */
	public static final KeywordOption MERGE_TYPE = new KeywordOption("--merge-type", "ARG"); //$NON-NLS-N$

	public final static String HELP = "Continue an interrupted rebase after resolving conflicts."; //$NON-NLS-N$
}
