/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.syntax;

import org.vcs.bazaar.client.commandline.commands.options.KeywordOption;
import org.vcs.bazaar.client.commandline.commands.options.Option;

/**
 * @author Piotr Piastucki
 */
public interface IUnShelveOptions {

	public final static String COMMAND = "unshelve"; //$NON-NLS-N$

	/**
	 * Display more information.
	 */
	public static final Option VERBOSE = new Option("--verbose"); //$NON-NLS-N$

	/**
	 * Only display errors and warnings.
	 */
	public static final Option QUIET = new Option("--quiet"); //$NON-NLS-N$

	/**
	 * Branch in which to place the tag.
	 */
	public static final KeywordOption DIRECTORY = new KeywordOption("--directory", "ARG"); //$NON-NLS-N$

	/**
	 * Apply changes and remove from the shelf.
	 */
	public static final Option APPLY = new Option("--apply"); //$NON-NLS-N$

	/**
	 * Delete changes without applying them.
	 */
	public static final Option DELETE_ONLY = new Option("--delete-only"); //$NON-NLS-N$

	/**
	 * Show changes, but do not apply or remove them.
	 */
	public static final Option DRY_RUN = new Option("--dry-run"); //$NON-NLS-N$

	/**
	 * Apply changes but don't delete them.
	 */
	public static final Option KEEP = new Option("--keep"); //$NON-NLS-N$
	
	/**
	 * Instead of unshelving the changes, show the diff that would result from unshelving.
	 */
	public static final Option PREVIEW = new Option("--preview"); //$NON-NLS-N$

	public final static String HELP = "Restore shelved changes."; //$NON-NLS-N$
}
