/**
 *
 */
package org.vcs.bazaar.client.xmlrpc;

import org.vcs.bazaar.client.IBzrError;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * BazaarClientException subclass to handle xmlrpc command errors
 *
 * @author Guillermo Gonzalez <guillo.gonzo AT gmail DOT com>
 */
public class XmlRpcCommandException extends BazaarClientException {

    private static final long serialVersionUID = 1L;
    private final IBzrError commandError;

	public static XmlRpcCommandException wrapException(Exception exception) {
		return new XmlRpcCommandException(exception.getMessage(), exception);
	}

	public XmlRpcCommandException(IBzrError bzrError) {
		super(bzrError.getMessage());
		this.commandError = bzrError;
	}

	protected XmlRpcCommandException(String message, Exception exception) {
		super(message, exception);
		this.commandError = null;
	}

	public IBzrError getCommandError() {
		return commandError;
	}

}
