/**
 * LICENCSE + COPYRIGHT
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;

import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarVersion;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

/**
 * @author Guillermo Gonzalez <guillo.gonzo@gmail.com>
 */
public class XMLVersionParserTest extends ParserTest {

	@Test 
	public void testParseVersion() throws BazaarClientException, IOException {
		BazaarVersion version = XMLVersionParser.parse(getContentsFrom(versionFile));
		Assert.assertNotNull(version);
		Assert.assertEquals(version.getVersion(), "2.0rc2");
		Assert.assertEquals(version.getBzrlib(), "/usr/lib/python2.6/dist-packages/bzrlib");
		Assert.assertEquals(version.getConfiguration(), "/home/guillermo/.bazaar");
		Assert.assertEquals(version.getLogFile(), "/home/guillermo/.bzr.log");
		Assert.assertEquals(version.getCopyright(), "Copyright 2005, 2006, 2007, 2008, 2009 Canonical " +
		        "Ltd.http://bazaar-vcs.org/bzr comes with ABSOLUTELY NO WARRANTY.  bzr " +
		        "is free software, andyou may use, modify and redistribute it under " +
		        "the terms of the GNUGeneral Public License version 2 or later.");
	}
}
