package org.vcs.bazaar.client.testUtils;

import java.io.File;
import java.io.InputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Ignore;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;

/**
 * configuration parameters that are common to all tests
 */
@Ignore
public final class TestsConfig {
	private static final Log LOG = LogFactory.getLog(TestsConfig.class);

	private static TestsConfig testsConfig;
	public String clientType;
	public File rootDir;
	public String rootDirName;
	public File workingCopies;

	public IBazaarClient client;
	public File defaultWorkingTreeLocation;
	public ExpectedWorkingTree defaultWorkingTree;

	// default username
	private static String username = "bzr-eclipse-user";
	private static String usermail = "bzr-eclipse-user@bzr.org";

	static {
		LOG.debug("Getting environment settings");
		final BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
		try {
			InputStream is = TestsConfig.class.getResourceAsStream("/tests.properties");
			Properties fileProps = new Properties();
			if(is != null) {
				fileProps.load(is);
				prefs.setFrom(fileProps);
			}

		} catch (Exception e) {
			LOG.error("Trouble getting environment settings", e);
		}

		if(prefs.getString(BazaarPreference.TEST_USER_NAME) != null) {
			username = prefs.getString(BazaarPreference.TEST_USER_NAME);
		}
		if(prefs.getString(BazaarPreference.TEST_USER_MAIL) != null) {
			usermail = prefs.getString(BazaarPreference.TEST_USER_MAIL);
		}
		prefs.set(BazaarPreference.BZR_EMAIL, getUserName());
		if(prefs.getString(BazaarPreference.EXECUTABLE) == null) {
			prefs.set(BazaarPreference.EXECUTABLE, "bzr");
		}

	}

	private TestsConfig() throws Exception {
		LOG.debug("Initializing client factories");
		try {
			BazaarClientFactory.setupBestAvailableBackend(true);
		} catch (BazaarClientException e) {
			LOG.error("Error initializing bzr backend", e);
			throw e;
		}
		clientType = BazaarClientPreferences.getInstance().getString(BazaarPreference.TEST_CLIENT_TYPE);
		if (clientType == null) {
			clientType = BazaarClientFactory.getPreferredClientType();
		}

		configureClient();
		rootDir = FileUtils.createTempDir("bazaar_client_tests", "");

		workingCopies = new File(rootDir, "working_copies");
		if (workingCopies.exists()) {
			LOG.debug("working_copies dir already exists, deleting it...");
			FileUtils.removeDirectoryWithContent(workingCopies);
		}
		workingCopies.mkdirs();

		// build the sample repository that will be imported
		defaultWorkingTreeLocation = new File(workingCopies, "default_branch");
		defaultWorkingTree = ExpectedStructureFactory.getWorkingTree();
	}

	/**
	 * Create an example file tree.
	 * @throws Exception If the working tree cannot be created
	 * @see #deleteWorkingTree()
	 */
	public void createWorkingTree() throws Exception {
        defaultWorkingTreeLocation.mkdir();
        defaultWorkingTree.materialize(defaultWorkingTreeLocation);

        LOG.debug("Creating branch:" + defaultWorkingTreeLocation.toString());
        File[] filesToAdd = defaultWorkingTreeLocation.listFiles();
        client.setWorkDir(defaultWorkingTreeLocation);
        client.init(defaultWorkingTreeLocation);
        client.add(filesToAdd);
        client.commit(new File[] { defaultWorkingTreeLocation }, "initial import");
	}

	/**
	 * Delete the example file tree.
	 * @see #createWorkingTree()
	 */
	public void deleteWorkingTree() {
	    FileUtils.removeDirectoryWithContent(rootDir);
	}

	private void configureClient() {
		LOG.info("Using client: " + clientType);
		client = BazaarClientFactory.createClient(clientType);
	}

	public static TestsConfig getTestsConfig() throws Exception {
		if (testsConfig == null) {
			testsConfig = new TestsConfig();
		}
		return testsConfig;
	}

	public static String getUserName() {
		return username + " <" + usermail + ">";
	}

	public static String getBzrMail() {
		return usermail;
	}
}
