/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.BazaarTreeStatus;
import org.vcs.bazaar.client.BazaarVersionInfo;
import org.vcs.bazaar.client.IBazaarAnnotation;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.IBazaarStatus;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.CommandLineClientFactory;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.ICommitOptions;
import org.vcs.bazaar.client.commandline.syntax.IInfoOptions;
import org.vcs.bazaar.client.commandline.syntax.ILogOptions;
import org.vcs.bazaar.client.commandline.syntax.IShelveOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;
import org.vcs.bazaar.client.testUtils.ExpectedWorkingTree;
import org.vcs.bazaar.client.testUtils.FileUtils;
import org.vcs.bazaar.client.utils.BazaarUtilities;
import org.vcs.bazaar.client.utils.StringUtil;

public class BazaarClientTest
extends BazaarTest {
    @Test
    public final void testAdd() throws Exception {
        Environment testEnv = new Environment("basicAdd", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File newDir = new File(testEnv.getWorkingTreeLocation(), "new_Dir");
        newDir.mkdirs();
        File newFile = new File(newDir, "new_File.txt");
        FileUtils.addContentToFile(newFile, "a new File");
        this.client.add(new File[]{newDir}, new Option[0]);
        testEnv.getExpectedWorkingTree().addItem("new_Dir", null);
        testEnv.getExpectedWorkingTree().setItemStatus("new_Dir", BazaarStatusKind.CREATED);
        testEnv.getExpectedWorkingTree().addItem("new_Dir/new_File.txt", "a new File");
        testEnv.getExpectedWorkingTree().addItem("new_Dir/a file with spaces in its name.txt", "a file with spaces");
        testEnv.getExpectedWorkingTree().setItemStatus("new_Dir/new_File.txt", BazaarStatusKind.CREATED);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
    }

    @Test
    public final void testAnnotate() throws Exception {
        Environment testEnv = new Environment("basicAnnotate", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File file = new File(testEnv.getWorkingTreeLocation(), "A/file_in_A");
        IBazaarAnnotation ann = this.client.annotate(file, new Option[0]);
        String[] expectedContent = testEnv.getExpectedWorkingTree().getItemContent("A/file_in_A").split(System.getProperty("line.separator"));
        Assert.assertEquals((String)"Line count", (long)expectedContent.length, (long)ann.getNumberOfLines());
        Assert.assertEquals((String)"File path", (Object)file.getCanonicalPath(), (Object)ann.getFile().getCanonicalPath());
        for (int i = 0; i < expectedContent.length; ++i) {
            Assert.assertEquals((String)"Author", (Object)BazaarClientTest.getBzrMail(), (Object)ann.getAuthor(i));
            Assert.assertEquals((String)"Code line", (Object)expectedContent[i], (Object)ann.getline(i));
        }
    }

    @Test
    public final void testBranch() throws Exception {
        Environment testEnv = new Environment("localBranch/original", this.getTestConfig());
        File newBranch = new File(testEnv.getWorkingTreeLocation().getParent(), "branch");
        this.client.setWorkDir(newBranch.getParentFile());
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), newBranch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), newBranch);
    }

    @Test
    public final void testCat() throws Exception {
        Environment testEnv = new Environment("simpleCat", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File file = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        String expectedContent = testEnv.getExpectedWorkingTree().getItemContent("file_in_root.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.client.cat(file, null, new Option[0])));
        String line = null;
        StringBuilder strBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            strBuilder.append(line);
        }
        Assert.assertEquals((Object)expectedContent.trim(), (Object)strBuilder.toString().trim());
    }

    @Test
    public final void testCheckout() throws Exception {
        Environment testEnv = new Environment("checkout/original", this.getTestConfig());
        File checkout = new File(testEnv.getWorkingTreeLocation().getParent(), "checkout");
        this.client.setWorkDir(checkout.getParentFile());
        BranchLocation branchLocation = new BranchLocation(testEnv.getWorkingTreeLocation().toURI());
        this.client.checkout(branchLocation, checkout, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), checkout);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInRoot = new File(checkout, "file_in_root.txt");
        FileUtils.addContentToFile(fileInRoot, textToAdd);
        this.client.setWorkDir(checkout);
        this.client.commit(new File[]{fileInRoot}, "commit made in the checkedout branch to test client.checkout(lightweight=true)", new Option[0]);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(checkout);
    }

    @Test
    public final void testCommit() throws Exception {
        Environment testEnv = new Environment("basicCommit", this.getTestConfig());
        BazaarRevision expectedRevision = BazaarRevision.getRevision((int)2);
        File fileInRoot = this.setUpCommitTest(testEnv, expectedRevision);
        this.client.commit(new File[]{fileInRoot}, "file_in_root.txt modified by testCommit", new Option[0]);
        testEnv.getExpectedWorkingTree().setItemRevision(fileInRoot.getName(), expectedRevision);
        Assert.assertEquals((String)"current revision diffier from expected", (Object)expectedRevision, (Object)this.client.revno(fileInRoot));
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
    }

    @Test
    public final void testCommitEncoding() throws Exception {
        Environment testEnv = new Environment("MessageVariantsCommit", this.getTestConfig());
        BazaarRevision expectedRevision = BazaarRevision.getRevision((int)2);
        File fileInRoot = this.setUpCommitTest(testEnv, expectedRevision);
        String commitMessage = "P\u0159\u00ed\u0161rn\u011b \u017elut\u00fd k\u016f\u0148 \u00fap\u011bl \u010f\u00e1belsk\u00e9 \u00f3dy (czech language)";
        this.client.commit(new File[]{fileInRoot}, commitMessage, new Option[]{ICommitOptions.UNCHANGED});
        testEnv.getExpectedWorkingTree().setItemRevision(fileInRoot.getName(), expectedRevision);
        Assert.assertEquals((String)"current revision diffier from expected", (Object)expectedRevision, (Object)this.client.revno(fileInRoot));
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        List logs = this.client.log(fileInRoot, new Option[]{ILogOptions.LIMIT.with("1")});
        if (logs.size() == 1) {
            Assert.assertArrayEquals((char[])commitMessage.toCharArray(), (char[])((IBazaarLogMessage)logs.get(0)).getMessage().toCharArray());
            Assert.assertEquals((Object)commitMessage, (Object)((IBazaarLogMessage)logs.get(0)).getMessage());
        } else {
            Assert.fail((String)"At least one log message is expected");
        }
    }

    @Test
    @Ignore(value="This test is failing due to a bad conversion of some control chars between xmloutput and bzr-java-lib")
    public final void testCommitMessageVariants() throws Exception {
        Environment testEnv = new Environment("MessageVariantsCommit", this.getTestConfig());
        BazaarRevision expectedRevision = BazaarRevision.getRevision((int)2);
        File fileInRoot = this.setUpCommitTest(testEnv, expectedRevision);
        String commitMessage = "file_in_root.txt \n \b \t \f \r \r\n \r \r \r \\ testCommit < ''| ";
        this.client.commit(new File[]{fileInRoot}, commitMessage, new Option[]{ICommitOptions.UNCHANGED});
        testEnv.getExpectedWorkingTree().setItemRevision(fileInRoot.getName(), expectedRevision);
        Assert.assertEquals((String)"current revision diffier from expected", (Object)expectedRevision, (Object)this.client.revno(fileInRoot));
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        List logs = this.client.log(fileInRoot, new Option[]{ILogOptions.LIMIT.with("1")});
        if (logs.size() == 1) {
            char[] expected = commitMessage.toCharArray();
            char[] actual = ((IBazaarLogMessage)logs.get(0)).getMessage().toCharArray();
            Assert.assertEquals((long)expected.length, (long)actual.length);
            for (int i = 0; i < expected.length; ++i) {
                Assert.assertEquals((String)("expected: " + expected[i] + "(" + Integer.toHexString(expected[i]) + ") but was: " + actual[i] + "(" + Integer.toHexString(actual[i]) + ") at char[" + i + "]"), (long)expected[i], (long)actual[i]);
            }
            Assert.assertEquals((Object)commitMessage, (Object)((IBazaarLogMessage)logs.get(0)).getMessage());
        } else {
            Assert.fail((String)"At least one log message is expected");
        }
    }

    private File setUpCommitTest(Environment testEnv, BazaarRevision expectedRevision) throws Exception {
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        String textToAdd = "this is text added to file_in_root.txt" + System.getProperty("line.separator");
        File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInRoot, textToAdd);
        testEnv.getExpectedWorkingTree().setItemStatus(fileInRoot.getName(), BazaarStatusKind.MODIFIED);
        String currentContent = testEnv.getExpectedWorkingTree().getItemContent(fileInRoot.getName());
        testEnv.getExpectedWorkingTree().setItemContent(fileInRoot.getName(), currentContent + textToAdd);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        return fileInRoot;
    }

    @Test
    public final void testDiff() throws Exception {
        Environment testEnv = new Environment("Diff", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File file = new File(testEnv.getWorkingTreeLocation(), "A/file_in_A");
        String textToAdd = System.getProperty("line.separator") + "content added to test diff" + System.getProperty("line.separator");
        FileUtils.addContentToFile(file, textToAdd);
        String aDiff = this.client.diff(new File[]{file}, null, new Option[0]);
        Assert.assertTrue((boolean)aDiff.contains("+content added to test diff"));
    }

    @Test
    public final void testInit() throws Exception {
        Environment testEnv = new Environment("simpleInit", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        try {
            this.client.init(testEnv.getWorkingTreeLocation(), new Option[0]);
        }
        catch (BazaarClientException bzrCliEx) {
            Assert.assertNotNull((Object)bzrCliEx.getMessage());
            Assert.assertTrue((boolean)bzrCliEx.getMessage().contains("Already a branch:"));
        }
    }

    @Test
    public final void testLog() throws Exception {
        Environment testEnv = new Environment("log", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        List logMsgs = this.client.log(testEnv.getWorkingTreeLocation(), new Option[0]);
        Assert.assertEquals((long)1L, (long)logMsgs.size());
        for (IBazaarLogMessage message : logMsgs) {
            Assert.assertEquals((Object)"default_branch", (Object)message.getBranchNick());
            Assert.assertEquals((Object)BazaarRevision.getRevision((int)1).getValue(), (Object)message.getRevision().getValue());
            Assert.assertEquals((Object)BazaarClientTest.getUserName(), (Object)message.getCommiter());
            Assert.assertEquals((Object)"initial import", (Object)message.getMessage().trim());
        }
    }

    @Test
    public final void testMove() throws Exception {
        Environment testEnv = new Environment("simpleMove", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File orig = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        File dest = new File(testEnv.getWorkingTreeLocation(), "A/");
        this.client.move(orig, dest, new Option[0]);
        testEnv.getExpectedWorkingTree().addItem("A/file_in_root.txt", testEnv.getExpectedWorkingTree().getItemContent("file_in_root.txt"));
        testEnv.getExpectedWorkingTree().removeItem("file_in_root.txt");
        testEnv.getExpectedWorkingTree().setItemStatus("A/file_in_root.txt", BazaarStatusKind.RENAMED);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        File[] filesToMove = new File[]{new File(testEnv.getWorkingTreeLocation(), "A/B/file_in_B"), new File(testEnv.getWorkingTreeLocation(), "A/file_in_A")};
        File destDir = testEnv.getWorkingTreeLocation();
        this.client.move(filesToMove, destDir, new Option[0]);
        testEnv.getExpectedWorkingTree().addItem("file_in_B", testEnv.getExpectedWorkingTree().getItemContent("A/B/file_in_B"));
        testEnv.getExpectedWorkingTree().addItem("file_in_A", testEnv.getExpectedWorkingTree().getItemContent("A/file_in_A"));
        testEnv.getExpectedWorkingTree().removeItem("A/B/file_in_B");
        testEnv.getExpectedWorkingTree().removeItem("A/file_in_A");
        testEnv.getExpectedWorkingTree().setItemStatus("file_in_B", BazaarStatusKind.RENAMED);
        testEnv.getExpectedWorkingTree().setItemStatus("file_in_A", BazaarStatusKind.RENAMED);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        File origDir = new File(testEnv.getWorkingTreeLocation(), "A/B/C");
        destDir = new File(testEnv.getWorkingTreeLocation(), "A/E/");
        this.client.move(origDir, destDir, new Option[0]);
        testEnv.getExpectedWorkingTree().addItem("A/E/C", null);
        testEnv.getExpectedWorkingTree().setItemStatus("A/E/C", BazaarStatusKind.RENAMED);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
    }

    @Test
    public final void testNick() throws Exception {
        Environment testEnv = new Environment("simpleNick", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        String nick = this.client.nick(null);
        Assert.assertEquals((Object)testEnv.getWorkingTreeLocation().getName().trim(), (Object)nick);
    }

    @Test
    public final void testPull() throws Exception {
        Environment testEnv = new Environment("Pull/parent", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "branched");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test client.pull", new Option[0]);
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(branch);
        this.client.pull(testEnv.getWorkingTreeLocation().toURI(), new Option[0]);
        Assert.assertEquals((Object)this.client.revno(testEnv.getWorkingTreeLocation()), (Object)this.client.revno(branch));
    }

    @Test
    public final void testPush() throws Exception {
        Environment testEnv = new Environment("push/remote", this.getTestConfig());
        File localBranch = new File(testEnv.getWorkingTreeLocation().getParent(), "local");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), localBranch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), localBranch);
        this.client.setWorkDir(localBranch);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(localBranch, "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the local branch to test client.push", new Option[0]);
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(localBranch);
        this.client.setWorkDir(localBranch);
        this.client.push(StringUtil.getAbsoluteURI((URI)testEnv.getWorkingTreeLocation().toURI()), new Option[0]);
        Assert.assertEquals((Object)this.client.revno(localBranch), (Object)this.client.revno(testEnv.getWorkingTreeLocation()));
    }

    @Test
    public final void testRemove() throws Exception {
        Environment testEnv = new Environment("singleFileRemove", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        Assert.assertTrue((boolean)fileInRoot.delete());
        testEnv.getExpectedWorkingTree().setItemStatus(fileInRoot.getName(), BazaarStatusKind.DELETED);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
    }

    @Test
    public final void testRevert() throws Exception {
        Environment testEnv = new Environment("singleFileRevert", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        String textToAdd = "///added text\\\\\\" + System.getProperty("line.separator");
        FileUtils.addContentToFile(fileInRoot, textToAdd);
        testEnv.getExpectedWorkingTree().setItemStatus(fileInRoot.getName(), BazaarStatusKind.MODIFIED);
        String previousContent = testEnv.getExpectedWorkingTree().getItemContent(fileInRoot.getName());
        testEnv.getExpectedWorkingTree().setItemContent(fileInRoot.getName(), previousContent + textToAdd);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.commit(new File[]{fileInRoot}, fileInRoot.getName() + " modified by testRevert", new Option[0]);
        testEnv.getExpectedWorkingTree().setItemRevision(fileInRoot.getName(), BazaarRevision.getRevision((int)2));
        Assert.assertEquals((String)"current revision diffier from expected", (Object)BazaarRevision.getRevision((int)2), (Object)this.client.revno(fileInRoot));
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.revert(new File[]{fileInRoot}, new Option[0]);
        testEnv.getExpectedWorkingTree().setItemRevision(fileInRoot.getName(), BazaarRevision.getRevision((int)1));
        testEnv.getExpectedWorkingTree().setItemStatus(fileInRoot.getName(), BazaarStatusKind.UNCHANGED);
        testEnv.getExpectedWorkingTree().setItemContent(fileInRoot.getName(), previousContent);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
    }

    @Test
    public final void testRevno() throws Exception {
        Environment testEnv = new Environment("Revno", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        BazaarRevision expectedRevision = BazaarRevision.getRevision((int)1);
        testEnv.getExpectedWorkingTree().setItemsRevision(expectedRevision);
        BazaarRevision result = this.client.revno(testEnv.getWorkingTreeLocation());
        Assert.assertEquals((Object)Integer.valueOf(expectedRevision.getValue().trim()), (Object)Integer.valueOf(result.getValue().trim()));
    }

    @Test
    public final void testRevisionInfo() throws IOException, BazaarClientException, Exception {
        Environment testEnv = new Environment("RevisionInfo", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        BazaarRevision result = this.client.revisionInfo(testEnv.getWorkingTreeLocation(), null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotSame((Object)result, (Object)BazaarRevision.INVALID);
    }

    @Test
    public final void testStatus() throws Exception {
        Environment testEnv = new Environment("Status", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        File fileInA = new File(testEnv.getWorkingTreeLocation(), "A/file_in_A");
        String newContent = "added content" + System.getProperty("line.separator");
        FileUtils.addContentToFile(fileInRoot, newContent);
        FileUtils.addContentToFile(fileInA, newContent);
        BazaarTreeStatus status = this.client.status(new File[]{fileInRoot, fileInA}, new Option[0]);
        Assert.assertEquals((String)"Expected status info for 2 files but..", (long)2L, (long)status.getStatus().size());
        for (IBazaarStatus elem : status.getStatus()) {
            File absoluteFile = new File(elem.getBranchRoot(), elem.getFile().getPath());
            if (absoluteFile.getCanonicalPath().equals(fileInRoot.getCanonicalPath()) || absoluteFile.getCanonicalPath().equals(fileInA.getCanonicalPath())) continue;
            Assert.fail((String)"recieved status for unexpected files!");
        }
    }

    @Test
    public final void testUnCommit() throws Exception {
        Environment testEnv = new Environment("singleFileRevert", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        String textToAdd = "///added text\\\\\\" + System.getProperty("line.separator");
        FileUtils.addContentToFile(fileInRoot, textToAdd);
        testEnv.getExpectedWorkingTree().setItemStatus(fileInRoot.getName(), BazaarStatusKind.MODIFIED);
        String previousContent = testEnv.getExpectedWorkingTree().getItemContent(fileInRoot.getName());
        testEnv.getExpectedWorkingTree().setItemContent(fileInRoot.getName(), previousContent + textToAdd);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.commit(new File[]{fileInRoot}, fileInRoot.getName() + " modified by testCommit", new Option[0]);
        testEnv.getExpectedWorkingTree().setItemRevision(fileInRoot.getName(), BazaarRevision.getRevision((int)2));
        Assert.assertEquals((String)"current revision diffier from expected", (Object)BazaarRevision.getRevision((int)2), (Object)this.client.revno(fileInRoot));
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.unCommit(testEnv.getWorkingTreeLocation(), new Option[0]);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
    }

    @Test
    public final void testIgnore() throws Exception {
        Environment testEnv = new Environment("Ignore", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File newFile = new File(testEnv.getWorkingTreeLocation(), "file_to_ignore");
        String textToAdd = "///added text\\\\\\" + System.getProperty("line.separator");
        FileUtils.addContentToFile(newFile, textToAdd);
        testEnv.getExpectedWorkingTree().addItem(newFile.getName(), textToAdd);
        testEnv.getExpectedWorkingTree().setItemStatus(newFile.getName(), BazaarStatusKind.UNKNOWN);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.ignore(testEnv.getWorkingTreeLocation(), newFile.getName());
        testEnv.getExpectedWorkingTree().removeItem(newFile.getName());
        testEnv.getExpectedWorkingTree().addItem(".bzrignore", newFile.getName() + "\n");
        testEnv.getExpectedWorkingTree().setItemStatus(".bzrignore", BazaarStatusKind.CREATED);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
    }

    @Test
    public final void testIgnored() throws Exception {
        Environment testEnv = new Environment("Ignored", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File newFile = new File(testEnv.getWorkingTreeLocation(), "file_to_ignore");
        String textToAdd = "///added text\\\\\\" + System.getProperty("line.separator");
        FileUtils.addContentToFile(newFile, textToAdd);
        testEnv.getExpectedWorkingTree().addItem(newFile.getName(), textToAdd);
        testEnv.getExpectedWorkingTree().setItemStatus(newFile.getName(), BazaarStatusKind.UNKNOWN);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.ignore(testEnv.getWorkingTreeLocation(), newFile.getName());
        testEnv.getExpectedWorkingTree().removeItem(newFile.getName());
        testEnv.getExpectedWorkingTree().addItem(".bzrignore", newFile.getName() + "\n");
        testEnv.getExpectedWorkingTree().setItemStatus(".bzrignore", BazaarStatusKind.CREATED);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.commit(new File[]{new File(testEnv.getWorkingTreeLocation(), ".bzrignore")}, "Added .bzrignore", new Option[0]);
        testEnv.getExpectedWorkingTree().setItemStatus(".bzrignore", BazaarStatusKind.NONE);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        Map result = this.client.ignored(testEnv.getWorkingTreeLocation());
        String unixPath = BazaarUtilities.unixFilePath((File)newFile);
        Assert.assertNotNull(result.get(unixPath));
        Assert.assertEquals((long)1L, (long)result.keySet().size());
        Assert.assertEquals((Object)newFile.getName(), result.get(unixPath));
        File a_dir = new File(testEnv.getWorkingTreeLocation(), "a_quite_long_named_directory");
        testEnv.getExpectedWorkingTree().addItem(a_dir.getName(), null);
        testEnv.getExpectedWorkingTree().setItemStatus(a_dir.getName(), BazaarStatusKind.CREATED);
        a_dir = new File(a_dir, "a_quite_long_named_directory");
        String a_dir_relativePath = BazaarUtilities.getRelativeTo((File)testEnv.getWorkingTreeLocation(), (File)a_dir).getPath();
        testEnv.getExpectedWorkingTree().addItem(a_dir_relativePath, null);
        testEnv.getExpectedWorkingTree().setItemStatus(a_dir_relativePath, BazaarStatusKind.CREATED);
        a_dir.mkdirs();
        this.client.add(new File[]{a_dir}, new Option[0]);
        this.client.commit(new File[]{a_dir}, "add the dir", new Option[0]);
        File largeFile = new File(a_dir, "file_to_ignore_with_a_long_name");
        largeFile.createNewFile();
        File largeRelFile = new File(a_dir_relativePath, largeFile.getName());
        String unixRelPath = BazaarUtilities.unixFilePath((File)largeRelFile);
        testEnv.getExpectedWorkingTree().addItem(unixRelPath, "");
        testEnv.getExpectedWorkingTree().setItemStatus(unixRelPath, BazaarStatusKind.UNKNOWN);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.ignore(testEnv.getWorkingTreeLocation(), largeRelFile.getPath());
        result = this.client.ignored(testEnv.getWorkingTreeLocation());
        Assert.assertNotNull(result.get(BazaarUtilities.unixFilePath((File)largeFile)));
        Assert.assertEquals((long)2L, (long)result.keySet().size());
        Assert.assertEquals((Object)unixRelPath, result.get(BazaarUtilities.unixFilePath((File)largeFile)));
    }

    @Test
    public final void testUnknowns() throws Exception {
        Environment testEnv = new Environment("unknowns", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root_new.txt");
        File fileInA = new File(testEnv.getWorkingTreeLocation(), "A/file_in_A_new");
        fileInRoot.createNewFile();
        fileInA.createNewFile();
        String[] unknowns = this.client.unknowns(testEnv.getWorkingTreeLocation());
        Assert.assertEquals((String)"Expected status info for 2 files but..", (long)2L, (long)unknowns.length);
        BazaarTreeStatus status = this.client.status(null, new Option[0]);
        Assert.assertEquals((String)"Expected status info for 2 files but..", (long)2L, (long)status.getStatus().size());
        for (IBazaarStatus elem : status.getStatus()) {
            if (elem.contains(BazaarStatusKind.UNKNOWN)) continue;
            Assert.fail((String)("file: " + elem.getAbsolutePath() + " isn't unknown"));
        }
    }

    @Test
    public final void testInfo() throws Exception {
        Environment testEnv = new Environment("info", this.getTestConfig());
        IBazaarInfo info = this.client.info(testEnv.getWorkingTreeLocation(), new Option[]{IInfoOptions.VERBOSE});
        Assert.assertNotNull((Object)info);
        Assert.assertNotNull((Object)info.getBranchFormat());
        Assert.assertNotNull((Object)info.getBranchHistory());
        Assert.assertNotNull((Object)info.getControlFormat());
        Assert.assertNotNull((Object)info.getLayout());
        Assert.assertNotNull((Object)info.getRepositoryFormat());
        Assert.assertNotNull((Object)info.getWorkingTreeFormat());
        Assert.assertNotNull((Object)info.getFormats());
        Assert.assertNotNull((Object)info.getLocations());
        Assert.assertNotNull((Object)info.getRelatedBranches());
        Assert.assertNotNull((Object)info.getRepositoryStats());
        Assert.assertNotNull((Object)info.getWorkingTreeStats());
    }

    @Test
    public final void testBind() throws Exception {
        Environment testEnv = new Environment("bind", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "branch_bind");
        BranchLocation source = new BranchLocation(testEnv.getWorkingTreeLocation());
        this.client.branch(source, branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        IBazaarInfo info = this.client.info(branch, new Option[0]);
        Assert.assertFalse((boolean)testEnv.getWorkingTreeLocation().getAbsolutePath().equals(info.getLocations().getCheckoutOfBranch()));
        this.client.setWorkDir(branch);
        this.client.bind(source, new Option[0]);
        info = this.client.info(branch, new Option[0]);
        Assert.assertEquals((Object)BazaarUtilities.unixFilePath((File)testEnv.getWorkingTreeLocation().getAbsoluteFile()), (Object)info.getLocations().getCheckoutOfBranch());
    }

    @Test
    public final void testUnBind() throws Exception {
        Environment testEnv = new Environment("bind", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "branch_unbind");
        BranchLocation source = new BranchLocation(testEnv.getWorkingTreeLocation());
        this.client.checkout(source, branch, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        this.client.setWorkDir(branch);
        IBazaarInfo info = this.client.info(branch, new Option[0]);
        Assert.assertEquals((Object)BazaarUtilities.unixFilePath((File)testEnv.getWorkingTreeLocation().getAbsoluteFile()), (Object)info.getLocations().getCheckoutOfBranch());
        this.client.unBind(new Option[0]);
        info = this.client.info(branch, new Option[0]);
        Assert.assertFalse((boolean)testEnv.getWorkingTreeLocation().getCanonicalPath().equals(info.getLocations().getCheckoutOfBranch()));
    }

    @Test
    public final void testSwitchBranch() throws Exception {
        Environment testEnv = new Environment("switch", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File branch1 = new File(testEnv.getWorkingTreeLocation().getParent(), "branch1");
        File branch2 = new File(testEnv.getWorkingTreeLocation().getParent(), "branch2");
        BranchLocation source = new BranchLocation(testEnv.getWorkingTreeLocation());
        this.client.checkout(source, branch1, new Option[0]);
        this.client.branch(source, branch2, null, new Option[0]);
        this.client.setWorkDir(branch2);
        File fileToCommit = this.setUpCommitTest(testEnv, BazaarRevision.getRevision((int)2));
        this.client.commit(new File[]{fileToCommit}, "test commit", new Option[0]);
        this.client.setWorkDir(branch1);
        IBazaarInfo info = this.client.info(new BranchLocation(branch1), new Option[0]);
        Assert.assertEquals((Object)BazaarUtilities.unixFilePath((File)testEnv.getWorkingTreeLocation().getAbsoluteFile()), (Object)info.getLocations().getCheckoutOfBranch());
        this.client.switchBranch(new BranchLocation(branch2), new Option[0]);
        IBazaarInfo infoPostSwitch = this.client.info(new BranchLocation(branch1), new Option[0]);
        Assert.assertEquals((Object)BazaarUtilities.unixFilePath((File)branch2.getAbsoluteFile()), (Object)infoPostSwitch.getLocations().getCheckoutOfBranch());
        BazaarRevision expectedRevno = this.client.revno(new BranchLocation(branch2));
        BazaarRevision actualRevno = this.client.revno(new BranchLocation(branch1));
        Assert.assertEquals((Object)expectedRevno, (Object)actualRevno);
    }

    @Test
    public final void testfindMergeBase() throws Exception {
        Environment testEnv = new Environment("findMergeBase/original", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "branch");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        BazaarRevision revision = this.client.findMergeBase(new BranchLocation(branch), new BranchLocation(testEnv.getWorkingTreeLocation()));
        Assert.assertNotNull((Object)revision);
        List logs = this.client.log(new BranchLocation(testEnv.getWorkingTreeLocation()), new Option[]{ILogOptions.REVISION.with("1"), ILogOptions.SHOW_IDS});
        Assert.assertEquals((Object)revision.getValue(), (Object)((IBazaarLogMessage)logs.get(0)).getRevisionId());
    }

    @Test
    public final void testLs() throws Exception {
        Environment testEnv = new Environment("ls", this.getTestConfig());
        File wtPath = testEnv.getWorkingTreeLocation();
        this.client.setWorkDir(wtPath);
        IBazaarItemInfo[] items = this.client.ls(wtPath, null, new Option[0]);
        ExpectedWorkingTree tree = testEnv.getExpectedWorkingTree();
        for (IBazaarItemInfo item : items) {
            File file = BazaarUtilities.getRelativeTo((File)wtPath, (File)new File(item.getPath()));
            String path = BazaarUtilities.unixFilePath((File)file);
            Assert.assertNotNull((String)path, (Object)tree.getItem(path));
            Assert.assertFalse((boolean)"".equals(tree.getItem(path).getPath().trim()));
        }
    }

    @Test
    public final void testMissing() throws Exception {
        Environment testEnv = new Environment("missing", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "missing_branched");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        this.client.setWorkDir(branch);
        Map missing = this.client.missing(branch, new BranchLocation(StringUtil.getAbsoluteURI((File)testEnv.getWorkingTreeLocation())), new Option[0]);
        Assert.assertNotNull((Object)missing);
        Assert.assertFalse((boolean)missing.containsKey("MINE"));
        Assert.assertFalse((boolean)missing.containsKey("OTHER"));
        Assert.assertEquals((long)0L, (long)missing.size());
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test missing", new Option[0]);
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(branch);
        missing = this.client.missing(branch, new BranchLocation(StringUtil.getAbsoluteURI((File)testEnv.getWorkingTreeLocation())), new Option[0]);
        Assert.assertNotNull((Object)missing);
        Assert.assertNotNull(missing.get("OTHER"));
        Assert.assertEquals((long)1L, (long)((List)missing.get("OTHER")).size());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        missing = this.client.missing(branch, new BranchLocation(StringUtil.getAbsoluteURI((File)branch)), new Option[0]);
        Assert.assertNotNull((Object)missing);
        Assert.assertNotNull(missing.get("MINE"));
        Assert.assertEquals((long)1L, (long)((List)missing.get("MINE")).size());
        File fileInBranch = new File(branch, "file_in_root.txt");
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        this.client.setWorkDir(branch);
        this.client.add(new File[]{fileInBranch}, new Option[0]);
        this.client.commit(new File[]{fileInBranch}, "commit made in the branch to test missing", new Option[0]);
        this.client.setWorkDir(branch.getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(branch);
        missing = this.client.missing(branch, new BranchLocation(StringUtil.getAbsoluteURI((File)testEnv.getWorkingTreeLocation())), new Option[0]);
        Assert.assertNotNull((Object)missing);
        Assert.assertNotNull(missing.get("MINE"));
        Assert.assertNotNull(missing.get("OTHER"));
        Assert.assertEquals((long)2L, (long)missing.size());
        Assert.assertEquals((long)1L, (long)((List)missing.get("MINE")).size());
        Assert.assertEquals((long)1L, (long)((List)missing.get("OTHER")).size());
    }

    @Test
    @Ignore
    public final void testUpdate() throws Exception {
        Assert.fail((String)"not Implemented");
    }

    @Test
    public final void testMerge() throws Exception {
        Environment testEnv = new Environment("merge", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "merge_branched");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test a merge", new Option[0]);
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(branch);
        this.client.merge(new BranchLocation(StringUtil.getAbsoluteURI((File)testEnv.getWorkingTreeLocation())), new Option[0]);
        BazaarTreeStatus treeStatus = this.client.status(new File[]{branch}, new Option[0]);
        IBazaarStatus[] status = treeStatus.getStatusAsArray();
        Assert.assertEquals((long)1L, (long)status.length);
        this.client.commit(new File[]{branch}, "merge with parent", new Option[0]);
        Assert.assertEquals((Object)"2", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)this.client.revno(testEnv.getWorkingTreeLocation()), (Object)this.client.revno(branch));
    }

    @Test
    public final void testResolve() throws Exception {
        Environment testEnv = new Environment("resolve", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "to_resolve");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test a merge", new Option[0]);
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(branch);
        File fileInBranch = new File(branch, "file_in_root.txt");
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        this.client.commit(new File[]{fileInBranch}, "commit made in the branch to produce a conflict", new Option[0]);
        try {
            this.client.merge(new BranchLocation(StringUtil.getAbsoluteURI((File)testEnv.getWorkingTreeLocation())), new Option[0]);
        }
        catch (BazaarClientException e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)"content don't match", (msg.contains("file_in_root.txt") && msg.contains("conflict") ? 1 : 0) != 0);
        }
        BazaarTreeStatus treeStatus = this.client.status(new File[]{branch}, new Option[0]);
        Assert.assertEquals((long)1L, (long)treeStatus.getStatus().size());
        IBazaarStatus[] status = treeStatus.getStatusAsArray();
        Assert.assertTrue((String)("status[0] \"" + status[0] + "\" don't have any conflicts"), (boolean)status[0].contains(BazaarStatusKind.HAS_CONFLICTS));
        ArrayList<File> files = new ArrayList<File>(1);
        files.add(status[0].getFile());
        this.client.resolve(files, new Option[0]);
        treeStatus = this.client.status(new File[]{branch}, new Option[0]);
        status = treeStatus.getStatus().toArray(new IBazaarStatus[0]);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertFalse((String)("status[0] \"" + status[0] + "\" have a conflict"), (boolean)status[0].contains(BazaarStatusKind.HAS_CONFLICTS));
        this.client.commit(new File[]{branch}, "merge with conflict resolution", new Option[0]);
        Assert.assertEquals((Object)"3", (Object)this.client.revno(branch).getValue());
    }

    @Test
    @Ignore
    public final void testSend() throws Exception {
        Assert.fail((String)"not Implemented");
    }

    @Test
    public final void testVersionInfo() throws Exception {
        Environment testEnv = new Environment("version-info", this.getTestConfig());
        BazaarVersionInfo info = this.client.versionInfo(new BranchLocation(testEnv.getWorkingTreeLocation()), new Option[0]);
        Assert.assertNotNull((Object)info);
        Assert.assertNotNull((Object)info.getBranchNick());
        Assert.assertNotNull((Object)info.getBuildDate());
        Assert.assertNotNull((Object)info.getDate());
        Assert.assertNotNull((Object)info.getRevid());
        Assert.assertNotNull((Object)info.getRevno());
    }

    @Test
    public final void testPlugins() throws IOException, BazaarClientException, Exception {
        Set plugins = this.client.plugins();
        Assert.assertTrue((plugins.size() >= 1 ? 1 : 0) != 0);
    }

    @Test
    public final void testProgress() throws Exception {
        Assume.assumeTrue((boolean)CommandLineClientFactory.checkXmlOutputVersion((int[])new int[]{0, 8, 9}));
        Environment testEnv = new Environment("progressBranch/origin", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "branch");
        this.client.setWorkDir(branch.getParentFile());
        final AtomicReference ref = new AtomicReference();
        IBazaarProgressListener listener = new IBazaarProgressListener(){

            public void logProgress(String message) {
                if (message != null && !message.isEmpty()) {
                    ref.set(message);
                }
            }
        };
        this.client.branch(new BranchLocation("lp:bzr-java-lib"), branch, null, listener, new Option[0]);
        Assert.assertNotNull(ref.get());
        Assert.assertFalse((boolean)((String)ref.get()).isEmpty());
    }

    protected boolean isPluginInstalled(String pluginName) throws BazaarClientException {
        Set plugins = this.client.plugins();
        for (IPlugin plugin : plugins) {
            if (!pluginName.equals(plugin.getName())) continue;
            return true;
        }
        return false;
    }

    @Test
    public final void testShelve() throws Exception {
        Assume.assumeTrue((boolean)CommandLineClientFactory.checkXmlOutputVersion((int[])new int[]{0, 8, 9}));
        Environment testEnv = new Environment("shelve", this.getTestConfig());
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileToShelve = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        String content = testEnv.getExpectedWorkingTree().getItemContent(fileToShelve.getName());
        FileUtils.addContentToFile(fileToShelve, textToAdd);
        testEnv.getExpectedWorkingTree().setItemStatus(fileToShelve.getName(), BazaarStatusKind.MODIFIED);
        testEnv.getExpectedWorkingTree().setItemContent(fileToShelve.getName(), content + textToAdd);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        this.client.shelve(new File[]{fileToShelve}, new Option[]{IShelveOptions.ALL});
        testEnv.getExpectedWorkingTree().setItemStatus(fileToShelve.getName(), BazaarStatusKind.UNCHANGED);
        testEnv.getExpectedWorkingTree().setItemContent(fileToShelve.getName(), content);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        Assert.assertEquals((long)1L, (long)this.client.shelveList(new Option[0]).size());
        this.client.unShelve(null, new Option[0]);
        testEnv.getExpectedWorkingTree().setItemStatus(fileToShelve.getName(), BazaarStatusKind.MODIFIED);
        testEnv.getExpectedWorkingTree().setItemContent(fileToShelve.getName(), content + textToAdd);
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        Assert.assertEquals((long)0L, (long)this.client.shelveList(new Option[0]).size());
    }

    @Test
    public final void testRebase() throws Exception {
        Assume.assumeTrue((boolean)this.isPluginInstalled("rewrite"));
        Environment testEnv = new Environment("rebase", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "rebase_branch");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test a rebase", new Option[0]);
        Assert.assertEquals((Object)"2", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        File fileInBranch = new File(branch, "file_in_branch.txt");
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        this.client.setWorkDir(branch);
        this.client.add(new File[]{fileInBranch}, new Option[0]);
        this.client.commit(new File[]{fileInBranch}, "commit made in the child branch to test a rebase", new Option[0]);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        this.client.rebase(new BranchLocation(StringUtil.getAbsoluteURI((File)branch)), new Option[0]);
        Assert.assertEquals((Object)"2", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)"3", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
    }

    @Test
    public final void testRebaseContinue() throws Exception {
        Assume.assumeTrue((boolean)this.isPluginInstalled("rewrite"));
        Environment testEnv = new Environment("rebase", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "rebase_continue_branch");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test a rebase", new Option[0]);
        Assert.assertEquals((Object)"2", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        File fileInBranch = new File(branch, "file_in_root.txt");
        textToAdd = "another text to add" + System.getProperty("line.separator");
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        this.client.setWorkDir(branch);
        this.client.add(new File[]{fileInBranch}, new Option[0]);
        this.client.commit(new File[]{fileInBranch}, "commit made in the child branch to test a rebase", new Option[0]);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        Assert.assertFalse((boolean)this.client.rebaseToDo(new Option[0]));
        Assert.assertEquals((Object)"2", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)"2", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        try {
            this.client.rebase(new BranchLocation(StringUtil.getAbsoluteURI((File)branch)), new Option[0]);
            Assert.fail((String)"A conflict expected while running rebase");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((Object)"2", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)"2", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        Assert.assertTrue((boolean)this.client.rebaseToDo(new Option[0]));
        ArrayList<File> files = new ArrayList<File>();
        files.add(fileInParent);
        this.client.resolve(files, new Option[0]);
        this.client.rebaseContinue(new Option[0]);
        Assert.assertEquals((Object)"2", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)"3", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        Assert.assertFalse((boolean)this.client.rebaseToDo(new Option[0]));
    }

    @Test
    public final void testRebaseAbort() throws Exception {
        Assume.assumeTrue((boolean)this.isPluginInstalled("rewrite"));
        Environment testEnv = new Environment("rebase", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "rebase_abort_branch");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test a rebase", new Option[0]);
        Assert.assertEquals((Object)"2", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        File fileInBranch = new File(branch, "file_in_branch.txt");
        textToAdd = "new file in branch" + System.getProperty("line.separator");
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        this.client.setWorkDir(branch);
        this.client.add(new File[]{fileInBranch}, new Option[0]);
        this.client.commit(new File[]{fileInBranch}, "commit made in the child branch to test a rebase", new Option[0]);
        fileInBranch = new File(branch, "file_in_root.txt");
        textToAdd = "another text to add" + System.getProperty("line.separator");
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        this.client.setWorkDir(branch);
        this.client.add(new File[]{fileInBranch}, new Option[0]);
        this.client.commit(new File[]{fileInBranch}, "2nd commit made in the child branch to test a rebase", new Option[0]);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        Assert.assertFalse((boolean)this.client.rebaseToDo(new Option[0]));
        Assert.assertEquals((Object)"3", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)"2", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        try {
            this.client.rebase(new BranchLocation(StringUtil.getAbsoluteURI((File)branch)), new Option[0]);
            Assert.fail((String)"A conflict expected while running rebase");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertEquals((Object)"3", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)"3", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        Assert.assertTrue((boolean)this.client.rebaseToDo(new Option[0]));
        ArrayList<File> files = new ArrayList<File>();
        files.add(fileInParent);
        this.client.rebaseAbort(new Option[0]);
        Assert.assertEquals((Object)"3", (Object)this.client.revno(branch).getValue());
        Assert.assertEquals((Object)"2", (Object)this.client.revno(testEnv.getWorkingTreeLocation()).getValue());
        Assert.assertFalse((boolean)this.client.rebaseToDo(new Option[0]));
    }

    @Test
    public final void testConflicts() throws Exception {
        Assume.assumeTrue((boolean)CommandLineClientFactory.checkXmlOutputVersion((int[])new int[]{0, 8, 9}));
        Environment testEnv = new Environment("resolve", this.getTestConfig());
        File branch = new File(testEnv.getWorkingTreeLocation().getParent(), "conflicts");
        this.client.branch(new BranchLocation(testEnv.getWorkingTreeLocation()), branch, null, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), branch);
        String textToAdd = "this is added text" + System.getProperty("line.separator");
        File fileInParent = new File(testEnv.getWorkingTreeLocation(), "file_in_root.txt");
        FileUtils.addContentToFile(fileInParent, textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        this.client.add(new File[]{fileInParent}, new Option[0]);
        this.client.commit(new File[]{fileInParent}, "commit made in the parent branch to test a merge", new Option[0]);
        testEnv.getExpectedWorkingTree().addItem(fileInParent.getName(), testEnv.getExpectedWorkingTree().getItemContent(fileInParent.getName()) + textToAdd);
        this.client.setWorkDir(testEnv.getWorkingTreeLocation().getParentFile());
        testEnv.checkStatusesExpectedWorkingTree(testEnv.getWorkingTreeLocation());
        testEnv.checkStatusesExpectedWorkingTree(branch);
        this.client.setWorkDir(branch);
        File fileInBranch = new File(branch, "file_in_root.txt");
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        FileUtils.addContentToFile(fileInBranch, textToAdd);
        this.client.commit(new File[]{fileInBranch}, "commit made in the branch to produce a conflict", new Option[0]);
        try {
            this.client.merge(new BranchLocation(StringUtil.getAbsoluteURI((File)testEnv.getWorkingTreeLocation())), new Option[0]);
        }
        catch (BazaarClientException e) {
            String msg = e.getMessage();
            Assert.assertTrue((String)"content don't match", (msg.contains("file_in_root.txt") && msg.contains("conflict") ? 1 : 0) != 0);
        }
        BazaarTreeStatus treeStatus = this.client.status(new File[]{branch}, new Option[0]);
        Assert.assertEquals((long)1L, (long)treeStatus.getStatus().size());
        IBazaarStatus[] status = treeStatus.getStatusAsArray();
        Assert.assertTrue((String)("status[0] \"" + status[0] + "\" don't have any conflicts"), (boolean)status[0].contains(BazaarStatusKind.HAS_CONFLICTS));
        List conflicts = this.client.conflicts(new Option[0]);
        Assert.assertEquals((long)1L, (long)conflicts.size());
        ArrayList<File> files = new ArrayList<File>(1);
        files.add(status[0].getFile());
        this.client.resolve(files, new Option[0]);
        treeStatus = this.client.status(new File[]{branch}, new Option[0]);
        status = treeStatus.getStatus().toArray(new IBazaarStatus[0]);
        Assert.assertEquals((long)1L, (long)status.length);
        Assert.assertFalse((String)("status[0] \"" + status[0] + "\" have a conflict"), (boolean)status[0].contains(BazaarStatusKind.HAS_CONFLICTS));
        conflicts = this.client.conflicts(new Option[0]);
        Assert.assertEquals((long)0L, (long)conflicts.size());
    }
}

