/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.ICleanTreeOptions;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;

public class CleanTreeTest
extends BazaarTest {
    @Test
    public final void testCleanTree() throws Exception {
        Environment testEnv = new Environment("clean-tree", this.getTestConfig());
        this.client.setWorkDir(testEnv.getWorkingTreeLocation());
        File fileInRoot = new File(testEnv.getWorkingTreeLocation(), "file_in_root_new.txt");
        File fileInA = new File(testEnv.getWorkingTreeLocation(), "A/file_in_A_new");
        fileInRoot.createNewFile();
        fileInA.createNewFile();
        String[] unknowns = this.client.unknowns(testEnv.getWorkingTreeLocation());
        Assert.assertEquals((String)"Unknown files", (long)2L, (long)unknowns.length);
        this.client.cleanTree(new Option[]{ICleanTreeOptions.FORCE});
        unknowns = this.client.unknowns(testEnv.getWorkingTreeLocation());
        Assert.assertEquals((String)"Unknown files", (long)0L, (long)unknowns.length);
    }
}

