/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.syntax.IReconfigureOptions;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.client.testUtils.BazaarTest;
import org.vcs.bazaar.client.testUtils.Environment;
import org.vcs.bazaar.client.testUtils.FileUtils;

public class ReconfigureTest
extends BazaarTest {
    @Test
    public final void testReconfigure() throws Exception {
        Environment testEnv = new Environment("reconfigure-tree", this.getTestConfig());
        File checkout = new File(testEnv.getWorkingTreeLocation().getParent(), "checkout");
        this.client.setWorkDir(checkout.getParentFile());
        this.client.checkout(new BranchLocation(testEnv.getWorkingTreeLocation().toURI()), checkout, new Option[0]);
        FileUtils.assertWTEqual(testEnv.getWorkingTreeLocation(), checkout);
        IBazaarInfo info = this.client.info(checkout, new Option[0]);
        Assert.assertEquals((Object)"Checkout", (Object)info.getLayout());
        this.client.reconfigure(new BranchLocation(checkout.toURI()), null, new Option[]{IReconfigureOptions.BRANCH});
        info = this.client.info(checkout, new Option[0]);
        Assert.assertEquals((Object)"Standalone branch", (Object)info.getLayout());
        this.client.reconfigure(new BranchLocation(checkout.toURI()), null, new Option[]{IReconfigureOptions.CHECKOUT});
        info = this.client.info(checkout, new Option[0]);
        Assert.assertEquals((Object)"Checkout", (Object)info.getLayout());
    }
}

