/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.BazaarItemKind;
import org.vcs.bazaar.client.BazaarStatusKind;
import org.vcs.bazaar.client.IBazaarItemInfo;
import org.vcs.bazaar.client.commandline.parser.XMLLsParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

public class XMLLsParserTest
extends ParserTest {
    @Test
    public void testparse() throws BazaarClientException, IOException {
        List items = XMLLsParser.parse((String)XMLLsParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/ls.xml"));
        Assert.assertNotNull((Object)items);
        Assert.assertFalse((items.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Number of items", (long)45L, (long)items.size());
        int fileCounter = 0;
        int dirCounter = 0;
        int symlinkCounter = 0;
        for (IBazaarItemInfo item : items) {
            fileCounter += BazaarItemKind.FILE.equals((Object)item.getKind()) ? 1 : 0;
            dirCounter += BazaarItemKind.DIRECTORY.equals((Object)item.getKind()) ? 1 : 0;
            symlinkCounter += BazaarItemKind.SYMLINK.equals((Object)item.getKind()) ? 1 : 0;
        }
        Assert.assertEquals((String)"Number of files", (long)44L, (long)fileCounter);
        Assert.assertEquals((String)"Number of directories", (long)1L, (long)dirCounter);
        Assert.assertEquals((String)"Number of symlinks", (long)0L, (long)symlinkCounter);
        int versionedCounter = 0;
        int ignoredCounter = 0;
        int unknownCounter = 0;
        for (IBazaarItemInfo item : items) {
            versionedCounter += BazaarStatusKind.VERSIONED.equals((Object)item.getStatusKind()) ? 1 : 0;
            ignoredCounter += BazaarStatusKind.IGNORED.equals((Object)item.getStatusKind()) ? 1 : 0;
            unknownCounter += BazaarStatusKind.UNKNOWN.equals((Object)item.getStatusKind()) ? 1 : 0;
        }
        Assert.assertEquals((String)"Number of versioned items", (long)21L, (long)versionedCounter);
        Assert.assertEquals((String)"Number of ignored items", (long)19L, (long)ignoredCounter);
        Assert.assertEquals((String)"Number of unknown items", (long)5L, (long)unknownCounter);
    }

    @Test
    public void testParseWithLog() throws BazaarClientException, IOException {
        List items = XMLLsParser.parse((String)XMLLsParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/ls_with_log.xml"));
        HashSet<String> revisions = new HashSet<String>();
        HashSet<String> committers = new HashSet<String>();
        Assert.assertNotNull((Object)items);
        Assert.assertFalse((items.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Incorrect number of items", (long)21L, (long)items.size());
        int fileCounter = 0;
        int dirCounter = 0;
        int symlinkCounter = 0;
        for (IBazaarItemInfo item : items) {
            fileCounter += BazaarItemKind.FILE.equals((Object)item.getKind()) ? 1 : 0;
            dirCounter += BazaarItemKind.DIRECTORY.equals((Object)item.getKind()) ? 1 : 0;
            symlinkCounter += BazaarItemKind.SYMLINK.equals((Object)item.getKind()) ? 1 : 0;
        }
        Assert.assertEquals((String)"Number of files", (long)21L, (long)fileCounter);
        Assert.assertEquals((String)"Number of directories", (long)0L, (long)dirCounter);
        Assert.assertEquals((String)"Number of symlinks", (long)0L, (long)symlinkCounter);
        int versionedCounter = 0;
        int ignoredCounter = 0;
        int unknownCounter = 0;
        for (IBazaarItemInfo item : items) {
            versionedCounter += BazaarStatusKind.VERSIONED.equals((Object)item.getStatusKind()) ? 1 : 0;
            ignoredCounter += BazaarStatusKind.IGNORED.equals((Object)item.getStatusKind()) ? 1 : 0;
            unknownCounter += BazaarStatusKind.UNKNOWN.equals((Object)item.getStatusKind()) ? 1 : 0;
        }
        Assert.assertEquals((String)"Number of versioned items", (long)9L, (long)versionedCounter);
        Assert.assertEquals((String)"Number of ignored items", (long)7L, (long)ignoredCounter);
        Assert.assertEquals((String)"Number of unknown items", (long)5L, (long)unknownCounter);
        for (IBazaarItemInfo item : items) {
            if (item.getLog() == null) continue;
            revisions.add(item.getLog().getRevision().toString());
            committers.add(item.getLog().getCommiter());
        }
        Assert.assertEquals((String)"Number of revisions", (long)5L, (long)revisions.size());
        Assert.assertEquals((String)"Number of committers", (long)3L, (long)committers.size());
        Assert.assertTrue((boolean)committers.contains("John"));
    }
}

