/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.text.ParseException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.parser.XMLPluginParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.testUtils.ParserTest;

public class XMLPluginParserTest
extends ParserTest {
    @Test
    public void testParse() throws ParseException, BazaarClientException, IOException {
        XMLPluginParser parser = new XMLPluginParser();
        Set plugins = parser.parse(XMLPluginParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/plugins.xml"));
        Assert.assertNotNull((Object)plugins);
        Assert.assertEquals((long)2L, (long)plugins.size());
        for (IPlugin plugin : plugins) {
            if ("xmloutput".equals(plugin.getName())) {
                Assert.assertEquals((Object)"xmloutput", (Object)plugin.getName());
                Assert.assertArrayEquals((Object[])new String[]{"0", "4", "2"}, (Object[])plugin.getVersion());
                Assert.assertEquals((Object)"/Users/guillermo/.bazaar/plugins/xmloutput", (Object)plugin.getPath());
                Assert.assertEquals((Object)"This plugin provides xml output for status, log, annotate,\n\t\t\tmissing, info, version and plugins adding a --xml option to\n\t\t\teach", (Object)plugin.getDescription());
                continue;
            }
            if ("launchpad".equals(plugin.getName())) {
                Assert.assertEquals((Object)"launchpad", (Object)plugin.getName());
                Assert.assertArrayEquals((Object[])new String[]{"unknown"}, (Object[])plugin.getVersion());
                Assert.assertEquals((Object)"/Users/guillermo/Projects/bazaar/bzr/dev/bzrlib/plugins/launchpad", (Object)plugin.getPath());
                Assert.assertEquals((Object)"Launchpad.net integration plugin for Bazaar.", (Object)plugin.getDescription());
                continue;
            }
            Assert.fail((String)("I have a unexpected plugin: " + plugin.getName()));
        }
    }

    @Test
    public void testParseMissingDocTag() throws ParseException, BazaarClientException, IOException {
        XMLPluginParser parser = new XMLPluginParser();
        Set plugins = parser.parse(XMLPluginParserTest.getContentsFrom("org/vcs/bazaar/client/commandline/parser/plugins_no_doc.xml"));
        Assert.assertNotNull((Object)plugins);
        Assert.assertEquals((long)3L, (long)plugins.size());
    }
}

