/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;

public class BranchLocationTest {
    private File tempDir;
    private String branchDir;
    private File theFile;

    @Before
    public void setUp() {
        this.tempDir = new File(System.getProperty("java.io.tmpdir"));
        this.branchDir = "C:/Documents and Settings/dangoore/My Documents/EclipseBZRWorkspace/MyProject";
        this.theFile = new File(this.tempDir, this.branchDir);
        this.theFile.mkdirs();
    }

    @After
    public void tearDown() {
        this.theFile.delete();
    }

    @Test
    public void testFilenameEncoding() throws BazaarClientException {
        BranchLocation l1 = new BranchLocation(this.theFile);
        BranchLocation l2 = new BranchLocation(this.theFile.getAbsolutePath());
        Assert.assertEquals((Object)this.theFile.getAbsolutePath(), (Object)l1.toString());
        Assert.assertEquals((Object)this.theFile.getAbsolutePath(), (Object)l2.toString());
    }

    @Test
    public void testLPEncoding() throws BazaarClientException {
        BranchLocation l1 = new BranchLocation("lp:bzr-java-lib");
        Assert.assertEquals((Object)"lp:bzr-java-lib", (Object)l1.toString());
    }

    @Test
    public void testURIEncoding() throws BazaarClientException, URISyntaxException {
        BranchLocation l1 = new BranchLocation(new URI("bzr+ssh://bazaar.launchpad.net/bzr-java-lib/bzr-java-lib/"));
        BranchLocation l2 = new BranchLocation("http://bazaar.launchpad.net/bzr%20java-lib/bzr-java-lib/");
        Assert.assertEquals((Object)"bzr+ssh://bazaar.launchpad.net/bzr-java-lib/bzr-java-lib/", (Object)l1.toString());
        Assert.assertEquals((Object)"http://bazaar.launchpad.net/bzr%20java-lib/bzr-java-lib/", (Object)l2.toString());
        Assert.assertEquals((Object)"http://bazaar.launchpad.net/bzr%20java-lib/bzr-java-lib/", (Object)l2.getUri().toString());
    }

    @Test
    public void testTrim() throws BazaarClientException {
        BranchLocation l1 = new BranchLocation("lp:bzr-java-lib ");
        Assert.assertEquals((Object)"lp:bzr-java-lib", (Object)l1.toString());
    }

    private BranchLocation serializeDeserialize(BranchLocation l) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(l);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return (BranchLocation)ois.readObject();
    }

    @Test
    public void testSerialization() throws Exception {
        BranchLocation l1 = new BranchLocation("lp:bzr-java-lib");
        BranchLocation l2 = new BranchLocation(new URI("bzr+ssh://bazaar.launchpad.net/bzr-java-lib/bzr-java-lib/"));
        BranchLocation l3 = new BranchLocation(this.theFile);
        BranchLocation dl1 = this.serializeDeserialize(l1);
        BranchLocation dl2 = this.serializeDeserialize(l2);
        BranchLocation dl3 = this.serializeDeserialize(l3);
        Assert.assertEquals((Object)l1.getScheme(), (Object)dl1.getScheme());
        Assert.assertEquals((Object)l1.getRaw(), (Object)dl1.getRaw());
        Assert.assertEquals((Object)l2.getScheme(), (Object)dl2.getScheme());
        Assert.assertEquals((Object)l2.getUri(), (Object)dl2.getUri());
        Assert.assertEquals((Object)l3.getScheme(), (Object)dl3.getScheme());
        Assert.assertEquals((Object)l3.getUri(), (Object)dl3.getUri());
    }
}

