/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.IBazaarLogMessage;
import org.vcs.bazaar.client.IBazaarPromptUserPassword;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BazaarClient
implements IBazaarClient {
    protected File workDir;
    protected IBazaarPromptUserPassword userPasswordPrompt;

    @Override
    public final void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    @Override
    public void addPasswordCallback(IBazaarPromptUserPassword callback) {
        this.userPasswordPrompt = callback;
    }

    public static final BazaarClientPreferences getPreferences() {
        return BazaarClientPreferences.getInstance();
    }

    protected abstract CommandRunner getCommandRunner();

    @Override
    public InputStream cat(File file, IBazaarRevisionSpec revision, Option ... options) throws BazaarClientException {
        return this.cat(file, revision, (String)null, options);
    }

    @Override
    public void move(File orig, File dest, Option ... options) throws BazaarClientException {
        this.move(new File[]{orig}, dest, options);
    }

    @Override
    public Map<String, List<IBazaarLogMessage>> missing(File workdir, URI otherBranch, Option ... options) throws BazaarClientException {
        return this.missing(workdir, new BranchLocation(otherBranch), options);
    }

    @Override
    public String pull(URI location, Option ... options) throws BazaarClientException {
        return this.pull(new BranchLocation(location), options);
    }

    @Override
    public void push(URI location, Option ... options) throws BazaarClientException {
        this.push(new BranchLocation(location), options);
    }

    @Override
    public BazaarRevision revno(File location) throws BazaarClientException {
        return this.revno(new BranchLocation(location));
    }

    @Override
    public IBazaarInfo info(File location, Option ... options) throws BazaarClientException {
        return this.info(new BranchLocation(location), options);
    }

    protected void notImplementedYet() throws BazaarClientException {
        throw new BazaarClientException("Not implemented");
    }
}

