/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline;

import org.vcs.bazaar.client.core.BazaarClientException;

public class CommandLineException
extends BazaarClientException {
    private static final long serialVersionUID = -8645734268757666362L;
    private static final int ERROR = 0;
    private static final int INFO = 1;
    private final String command;

    public CommandLineException(String message, String command) {
        super(message);
        this.command = command;
    }

    public CommandLineException(Throwable cause, String command) {
        super(cause.getMessage(), cause);
        this.setStackTrace(cause.getStackTrace());
        this.command = command;
    }

    public static CommandLineException wrapException(Exception e) {
        return new CommandLineException(e, "");
    }

    public String getMessageError() {
        String[] message = this.getMessage().split(System.getProperty("line.separator"));
        String error = message[0];
        return error;
    }

    public String getMessageInfo() {
        String[] message = this.getMessage().split(System.getProperty("line.separator"));
        if (message.length > 1) {
            return message[1];
        }
        return this.getMessage();
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isCommandLine() {
        return true;
    }
}

