/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.commands.MultiFileCommand;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.commandline.syntax.ICommitOptions;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.Assert;

public class Commit
extends MultiFileCommand
implements ICommitOptions {
    private final String message;

    public Commit(File workDir, File[] files, String message) {
        super(workDir, files);
        Assert.isTrue(message.trim().length() > 0);
        this.message = message;
        this.checkExitValue = false;
    }

    public String getCommand() {
        return "commit";
    }

    public void execute(CommandRunner runner) throws BazaarClientException {
        File tempFile = this.createMessageTempFile();
        try {
            this.setOption(ICommitOptions.FILE.with(tempFile.getPath()));
            super.execute(runner);
        }
        catch (CommandLineException e) {
            throw e;
        }
        finally {
            tempFile.delete();
        }
    }

    private File createMessageTempFile() throws CommandLineException {
        File tempFile = null;
        OutputStreamWriter osw = null;
        try {
            tempFile = File.createTempFile("bzr", "_log_message");
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "utf-8");
            osw.write(this.message);
        }
        catch (IOException e) {
            throw CommandLineException.wrapException(e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    throw CommandLineException.wrapException(e);
                }
            }
        }
        return tempFile;
    }
}

