/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.internal;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.vcs.bazaar.client.commandline.CmdLineClientTexts;
import org.vcs.bazaar.client.commandline.CommandLineException;
import org.vcs.bazaar.client.commandline.ICommand;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.BazaarUtilities;
import org.vcs.bazaar.client.utils.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Command
implements ICommand {
    private CommandRunner runner;
    protected File workDir;
    protected List<Option> options = new ArrayList<Option>();
    protected boolean checkExitValue = true;

    protected Command() {
    }

    protected Command(File workDir) {
        this();
        this.workDir = workDir;
    }

    public abstract String getCommand();

    @Override
    public String getCommandInfo() throws BazaarClientException {
        return CmdLineClientTexts.bind("Command.executing", new String[]{this.getCmdLineAsString()});
    }

    @Override
    public int getEstimatedWork() {
        return 100;
    }

    public void execute(CommandRunner runner) throws BazaarClientException {
        try {
            this.runner = runner;
            this.runner.runCommand(this, this.workDir);
        }
        catch (IOException e) {
            throw new CommandLineException(e, this.getCommand());
        }
        catch (InterruptedException e) {
            throw new CommandLineException(e, this.getCommand());
        }
    }

    public List<String> constructCommandInvocationString() throws CommandLineException {
        List<String> arguments = this.getArguments();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.addAll(this.defaultCmdLine());
        for (Option option : this.options) {
            if (option == null) {
                CommandLineException cle = new CommandLineException("Command option cannot be null", this.getCommand());
                cle.setStackTrace(CommandLineException.getCurrentStackTrace());
                throw cle;
            }
            String strOption = option.toString();
            if (strOption.length() <= 0) continue;
            commandLine.add(strOption);
        }
        commandLine.addAll(arguments);
        return commandLine;
    }

    @Override
    public void setOption(Option option) {
        if (!this.options.contains(option)) {
            this.options.add(option);
        }
    }

    @Override
    public String getCommandError() {
        return CmdLineClientTexts.bind("Command.error", new String[]{this.getCommand()});
    }

    public String getStandardError() {
        return this.runner.getStandardError();
    }

    public String getStandardOutput() {
        return this.runner.getStandardOutput();
    }

    public String getStandardOutput(String charsetName) throws UnsupportedEncodingException {
        return this.runner.getStandardOutput(charsetName);
    }

    public String[] getStandardOutputSplit() {
        return this.runner.getStandardOutputSplit();
    }

    protected List<String> defaultCmdLine() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getCommand());
        return result;
    }

    protected abstract List<String> getArguments() throws CommandLineException;

    protected List<String> getArguments(String arg) {
        ArrayList<String> args = new ArrayList<String>();
        if (arg != null) {
            args.add(arg);
        }
        return args;
    }

    protected List<String> getArguments(String arg1, String arg2) {
        List<String> args = this.getArguments(arg1);
        args.add(arg2);
        return args;
    }

    protected List<String> getEmptyArguments() {
        return new ArrayList<String>();
    }

    protected String getCmdLineAsString() throws CommandLineException {
        StringBuilder cmdLine = new StringBuilder();
        for (String part : this.constructCommandInvocationString()) {
            cmdLine.append(StringUtil.shellQuote(part));
            cmdLine.append(" ");
        }
        return cmdLine.toString();
    }

    protected File getRelativeToWorkDir(File file) {
        return BazaarUtilities.getRelativeTo(this.workDir, file);
    }

    public void setEnviroment(ProcessBuilder pb) {
    }

    public boolean isCheckExitValue() {
        return this.checkExitValue;
    }
}

