/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.commandline.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.vcs.bazaar.client.IBazaarInfo;
import org.vcs.bazaar.client.commandline.CommandLineInfo;
import org.vcs.bazaar.client.commandline.parser.XMLParser;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StringUtil;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLInfoParser
extends XMLParser {
    private static final String INFO = "info";
    private static final String LAYOUT = "layout";
    private static final String FORMATS = "formats";
    private static final String FORMAT = "format";
    private static final String LOCATION = "location";
    private static final String LOCATION_LIGHT_CHECKOUT_ROOT = "light_checkout_root";
    private static final String LOCATION_REPOSITORY_CHECKOUT_ROOT = "repository_checkout_root";
    private static final String LOCATION_CHECKOUT_ROOT = "checkout_root";
    private static final String LOCATION_CHECKOUT_OF_BRANCH = "checkout_of_branch";
    private static final String LOCATION_SHARED_REPOSITORY = "shared_repository";
    private static final String LOCATION_REPOSITORY = "repository";
    private static final String LOCATION_REPOSITORY_BRANCH = "repository_branch";
    private static final String LOCATION_BRANCH_ROOT = "branch_root";
    private static final String LOCATION_BOUND_TO_BRANCH = "bound_to_branch";
    private static final String RELATED_BRANCHES = "related_branches";
    private static final String PUBLIC_BRANCH = "public_branch";
    private static final String PUSH_BRANCH = "push_branch";
    private static final String PARENT_BRANCH = "parent_branch";
    private static final String SUBMIT_BRANCH = "submit_branch";
    private static final String CONTROL = "control";
    private static final String WORKING_TREE = "working_tree";
    private static final String BRANCH = "branch";
    private static final String REPOSITORY = "repository";
    private static final String WORKING_TREE_STATS = "working_tree_stats";
    private static final String UNCHANGED = "unchanged";
    private static final String MODIFIED = "modified";
    private static final String ADDED = "added";
    private static final String REMOVED = "removed";
    private static final String RENAMED = "renamed";
    private static final String UNKNOWN = "unknown";
    private static final String IGNORED = "ignored";
    private static final String VERSIONED_SUBDIRECTORIES = "versioned_subdirectories";
    private static final String BRANCH_HISTORY = "branch_history";
    private static final String REVISIONS = "revisions";
    private static final String COMMITTERS = "committers";
    private static final String DAYS_OLD = "days_old";
    private static final String FIRST_REVISION = "first_revision";
    private static final String LATEST_REVISION = "latest_revision";
    private static final String REPOSITORY_STATS = "repository_stats";
    private static final String SIZE = "size";

    public IBazaarInfo parse(String xml) throws BazaarClientException {
        this.parser = new KXmlParser();
        try {
            this.parser.setInput((Reader)new StringReader(xml));
            int eventType = this.parser.getEventType();
            CommandLineInfo info = null;
            while (eventType != 1) {
                if (eventType == 2 && INFO.equals(this.parser.getName())) {
                    info = this.parseInfo();
                }
                eventType = this.parser.next();
            }
            return info;
        }
        catch (XmlPullParserException e) {
            throw BazaarClientException.wrapException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw BazaarClientException.wrapException(e);
        }
        catch (ParseException e) {
            throw BazaarClientException.wrapException(e);
        }
    }

    private CommandLineInfo parseInfo() throws XmlPullParserException, IOException, ParseException {
        int eventType = this.parser.next();
        String layout = null;
        String workingTreeFormat = null;
        String branchFormat = null;
        String repositoryFormat = null;
        String controlFormat = null;
        List<String> formats = Collections.emptyList();
        CommandLineInfo.CmdLineLocations locations = null;
        CommandLineInfo.CmdLineRelatedBranches relatedBranches = null;
        CommandLineInfo.CmdLineWorkingTreeStats workingTreeStats = null;
        CommandLineInfo.CmdLineBranchHistory branchHistory = null;
        CommandLineInfo.CmdLineRepositoryStats repositoryStats = null;
        while (eventType != 1 || eventType == 3 && INFO.equals(this.parser.getName())) {
            if (eventType == 2 && LAYOUT.equals(this.parser.getName())) {
                layout = this.parser.nextText();
            } else if (eventType == 2 && FORMATS.equals(this.parser.getName())) {
                formats = this.parseFormats();
            } else if (eventType == 2 && LOCATION.equals(this.parser.getName())) {
                locations = this.parseLocations();
            } else if (eventType == 2 && RELATED_BRANCHES.equals(this.parser.getName())) {
                relatedBranches = this.parseRelatedBranches();
            } else if (eventType == 2 && FORMAT.equals(this.parser.getName())) {
                int formatEventType = this.parser.next();
                while (formatEventType != 1 || formatEventType == 3 && FORMAT.equals(this.parser.getName())) {
                    if (formatEventType == 2 && CONTROL.equals(this.parser.getName())) {
                        controlFormat = StringUtil.nullSafeTrim(this.parser.nextText());
                    } else if (formatEventType == 2 && WORKING_TREE.equals(this.parser.getName())) {
                        workingTreeFormat = StringUtil.nullSafeTrim(this.parser.nextText());
                    } else if (formatEventType == 2 && BRANCH.equals(this.parser.getName())) {
                        branchFormat = StringUtil.nullSafeTrim(this.parser.nextText());
                    } else if (formatEventType == 2 && "repository".equals(this.parser.getName())) {
                        repositoryFormat = StringUtil.nullSafeTrim(this.parser.nextText());
                    } else if (formatEventType == 3 && FORMAT.equals(this.parser.getName())) break;
                    formatEventType = this.parser.next();
                }
            } else if (eventType == 2 && WORKING_TREE_STATS.equals(this.parser.getName())) {
                workingTreeStats = this.parseWorkingTreeStats();
            } else if (eventType == 2 && BRANCH_HISTORY.equals(this.parser.getName())) {
                branchHistory = this.parseBranchHistory();
            } else if (eventType == 2 && REPOSITORY_STATS.equals(this.parser.getName())) {
                repositoryStats = this.parseRepositoryStats();
            }
            eventType = this.parser.next();
        }
        return new CommandLineInfo(layout, formats.toArray(new String[0]), branchFormat, controlFormat, repositoryFormat, workingTreeFormat, locations, relatedBranches, workingTreeStats, branchHistory, repositoryStats);
    }

    private List<String> parseFormats() throws XmlPullParserException, IOException {
        int eventType = this.parser.next();
        ArrayList<String> formats = new ArrayList<String>();
        while (eventType != 1 || eventType == 3 && FORMATS.equals(this.parser.getName())) {
            if (eventType == 2 && FORMAT.equals(this.parser.getName())) {
                formats.add(StringUtil.nullSafeTrim(this.parser.nextText()));
            } else if (eventType == 3 && FORMATS.equals(this.parser.getName())) {
                return formats;
            }
            eventType = this.parser.next();
        }
        return formats;
    }

    private CommandLineInfo.CmdLineLocations parseLocations() throws XmlPullParserException, IOException {
        int eventType = this.parser.next();
        String checkoutOfBranch = null;
        String checkoutRoot = null;
        String repositoryCheckoutRoot = null;
        String lightCheckoutRoot = null;
        String boundToBranch = null;
        String branchRoot = null;
        String repositoryBranch = null;
        String repository = null;
        String sharedRepository = null;
        while (eventType != 1 || eventType == 3 && LOCATION.equals(this.parser.getName())) {
            if (eventType == 2 && LOCATION_BOUND_TO_BRANCH.equals(this.parser.getName())) {
                boundToBranch = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && LOCATION_BRANCH_ROOT.equals(this.parser.getName())) {
                branchRoot = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && LOCATION_CHECKOUT_OF_BRANCH.equals(this.parser.getName())) {
                checkoutOfBranch = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && LOCATION_CHECKOUT_ROOT.equals(this.parser.getName())) {
                checkoutRoot = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && LOCATION_LIGHT_CHECKOUT_ROOT.equals(this.parser.getName())) {
                lightCheckoutRoot = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && "repository".equals(this.parser.getName())) {
                repository = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && LOCATION_REPOSITORY_BRANCH.equals(this.parser.getName())) {
                repositoryBranch = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && LOCATION_REPOSITORY_CHECKOUT_ROOT.equals(this.parser.getName())) {
                repositoryCheckoutRoot = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && LOCATION_SHARED_REPOSITORY.equals(this.parser.getName())) {
                sharedRepository = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 3 && LOCATION.equals(this.parser.getName())) break;
            eventType = this.parser.next();
        }
        return new CommandLineInfo.CmdLineLocations(lightCheckoutRoot, repositoryCheckoutRoot, checkoutRoot, checkoutOfBranch, sharedRepository, repository, repositoryBranch, branchRoot, boundToBranch);
    }

    private CommandLineInfo.CmdLineRelatedBranches parseRelatedBranches() throws XmlPullParserException, IOException {
        int eventType = this.parser.next();
        String publicBranch = null;
        String push = null;
        String parent = null;
        String submit = null;
        while (eventType != 1 || eventType == 3 && RELATED_BRANCHES.equals(this.parser.getName())) {
            if (eventType == 2 && PUBLIC_BRANCH.equals(this.parser.getName())) {
                publicBranch = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && PUSH_BRANCH.equals(this.parser.getName())) {
                push = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && PARENT_BRANCH.equals(this.parser.getName())) {
                parent = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 2 && SUBMIT_BRANCH.equals(this.parser.getName())) {
                submit = StringUtil.nullSafeTrim(this.parser.nextText());
            } else if (eventType == 3 && RELATED_BRANCHES.equals(this.parser.getName())) break;
            eventType = this.parser.next();
        }
        return new CommandLineInfo.CmdLineRelatedBranches(publicBranch, push, parent, submit);
    }

    private CommandLineInfo.CmdLineWorkingTreeStats parseWorkingTreeStats() throws XmlPullParserException, IOException {
        Integer versionedSubDirs;
        int eventType = this.parser.next();
        Integer ignored = versionedSubDirs = Integer.valueOf(0);
        Integer unknown = versionedSubDirs;
        Integer renamed = versionedSubDirs;
        Integer removed = versionedSubDirs;
        Integer added = versionedSubDirs;
        Integer modified = versionedSubDirs;
        Integer unchanged = versionedSubDirs;
        while (eventType != 1 || eventType == 3 && WORKING_TREE_STATS.equals(this.parser.getName())) {
            if (eventType == 2 && UNCHANGED.equals(this.parser.getName())) {
                unchanged = new Integer(this.parser.nextText());
            } else if (eventType == 2 && MODIFIED.equals(this.parser.getName())) {
                modified = new Integer(this.parser.nextText());
            } else if (eventType == 2 && ADDED.equals(this.parser.getName())) {
                added = new Integer(this.parser.nextText());
            } else if (eventType == 2 && REMOVED.equals(this.parser.getName())) {
                removed = new Integer(this.parser.nextText());
            } else if (eventType == 2 && RENAMED.equals(this.parser.getName())) {
                renamed = new Integer(this.parser.nextText());
            } else if (eventType == 2 && UNKNOWN.equals(this.parser.getName())) {
                unknown = new Integer(this.parser.nextText());
            } else if (eventType == 2 && IGNORED.equals(this.parser.getName())) {
                ignored = new Integer(this.parser.nextText());
            } else if (eventType == 2 && VERSIONED_SUBDIRECTORIES.equals(this.parser.getName())) {
                versionedSubDirs = new Integer(this.parser.nextText());
            } else if (eventType == 3 && WORKING_TREE_STATS.equals(this.parser.getName())) break;
            eventType = this.parser.next();
        }
        return new CommandLineInfo.CmdLineWorkingTreeStats(added, ignored, modified, removed, renamed, unchanged, unknown, versionedSubDirs);
    }

    private CommandLineInfo.CmdLineBranchHistory parseBranchHistory() throws XmlPullParserException, IOException, ParseException {
        Integer days;
        int eventType = this.parser.next();
        Integer committers = days = Integer.valueOf(0);
        Integer revisions = days;
        Date firstRevDate = null;
        Date lastRevDate = null;
        while (eventType != 1 || eventType == 3 && BRANCH_HISTORY.equals(this.parser.getName())) {
            String timestamp;
            if (eventType == 2 && REVISIONS.equals(this.parser.getName())) {
                revisions = new Integer(this.parser.nextText());
            } else if (eventType == 2 && COMMITTERS.equals(this.parser.getName())) {
                committers = new Integer(this.parser.nextText());
            } else if (eventType == 2 && DAYS_OLD.equals(this.parser.getName())) {
                days = new Integer(this.parser.nextText());
            } else if (eventType == 2 && FIRST_REVISION.equals(this.parser.getName())) {
                timestamp = StringUtil.nullSafeTrim(this.parser.nextText());
                firstRevDate = StringUtil.parseLogDate(timestamp);
            } else if (eventType == 2 && LATEST_REVISION.equals(this.parser.getName())) {
                timestamp = StringUtil.nullSafeTrim(this.parser.nextText());
                lastRevDate = StringUtil.parseLogDate(timestamp);
            } else if (eventType == 3 && BRANCH_HISTORY.equals(this.parser.getName())) break;
            eventType = this.parser.next();
        }
        return new CommandLineInfo.CmdLineBranchHistory(revisions, committers, days, firstRevDate, lastRevDate);
    }

    private CommandLineInfo.CmdLineRepositoryStats parseRepositoryStats() throws XmlPullParserException, IOException {
        int eventType = this.parser.next();
        Integer revisions = null;
        Long size = null;
        while (eventType != 1 || eventType == 3 && REPOSITORY_STATS.equals(this.parser.getName())) {
            if (eventType == 2 && REVISIONS.equals(this.parser.getName())) {
                revisions = new Integer(this.parser.nextText());
            } else if (eventType == 2 && SIZE.equals(this.parser.getName())) {
                size = new Long(this.parser.nextText());
            } else if (eventType == 3 && REPOSITORY_STATS.equals(this.parser.getName())) break;
            eventType = this.parser.next();
        }
        return new CommandLineInfo.CmdLineRepositoryStats(revisions, size);
    }
}

