/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.core;

import org.vcs.bazaar.client.commandline.CommandLineException;

public class BazaarClientException
extends Exception {
    private static final long serialVersionUID = -3048005644862762989L;
    private String error;
    private String info;

    public static RuntimeException makeUnChecked(Exception exception) {
        return new BazaarUncheckedException(exception);
    }

    public static BazaarClientException wrapException(Exception exception) {
        return new BazaarClientException(exception.getMessage(), exception);
    }

    public static BazaarClientException wrapException(CommandLineException exception) {
        return new BazaarClientException(exception);
    }

    public BazaarClientException(Exception exception) {
        super(exception.getMessage(), exception.getCause());
    }

    public BazaarClientException(String message) {
        super(message);
    }

    public BazaarClientException(String message, Throwable t) {
        super(message, t);
        this.setStackTrace(t.getStackTrace());
    }

    public BazaarClientException(CommandLineException e) {
        this(e.getMessage(), e);
        this.error = e.getMessageError();
        this.info = e.getMessageInfo();
    }

    public String getError() {
        return this.error;
    }

    public String getInfo() {
        return this.info;
    }

    public boolean isCommandLine() {
        return this.getCause() instanceof CommandLineException;
    }

    public String getCommand() {
        if (this.getCause() instanceof CommandLineException) {
            return ((CommandLineException)this.getCause()).getCommand();
        }
        return null;
    }

    public static StackTraceElement[] getCurrentStackTrace() {
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        System.arraycopy(st, 3, st, 0, st.length - 3);
        return st;
    }

    public static class BazaarUncheckedException
    extends RuntimeException {
        private static final long serialVersionUID = -4469538621094655850L;

        public BazaarUncheckedException(Exception exception) {
            super(exception.getMessage(), exception.getCause());
            this.setStackTrace(exception.getStackTrace());
        }

        public BazaarUncheckedException(String message) {
            super(message);
        }
    }
}

