/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.commandline.commands.Plugins;
import org.vcs.bazaar.client.commandline.internal.ShellCommandRunner;
import org.vcs.bazaar.client.commandline.parser.XMLPluginParser;
import org.vcs.bazaar.client.core.BazaarClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BazaarUtilities {
    private static final Log LOG = LogFactory.getLog(BazaarUtilities.class);
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    protected static final boolean isWindows() {
        return '\\' == File.separatorChar;
    }

    public static File getRootBranch(File file) {
        while (file.isFile() || !file.exists()) {
            file = file.getParentFile();
        }
        File[] files = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().equals(".bzr");
            }
        });
        if (files.length == 0) {
            File parent = file.getParentFile();
            return parent != null ? BazaarUtilities.getRootBranch(parent) : null;
        }
        return file;
    }

    public static final File getRelativeTo(File base, File file) {
        String normalizedBase = BazaarUtilities.unixFilePath(base);
        String normalizedFile = BazaarUtilities.unixFilePath(file);
        String[] workDirElements = normalizedBase.split("/");
        String[] fileElements = normalizedFile.split("/");
        File relativeFile = file;
        for (int elementIdx = 0; elementIdx < fileElements.length; ++elementIdx) {
            if (elementIdx < workDirElements.length && workDirElements[elementIdx].equals(fileElements[elementIdx])) {
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = elementIdx; i < fileElements.length; ++i) {
                sb.append(fileElements[i]).append(File.separator);
            }
            relativeFile = new File(sb.toString());
            return relativeFile;
        }
        return file;
    }

    public static final String unixFilePath(File file) {
        String path = "";
        if (file != null) {
            path = file.getPath();
        }
        if (path == null || path.indexOf(92) == -1) {
            return path;
        }
        return path.replace('\\', '/');
    }

    public static final List<String> getWindowsExecutable(String executable) throws IOException {
        File batfile = new File(executable);
        FileReader fr = new FileReader(batfile);
        BufferedReader br = new BufferedReader(fr);
        String exe = br.readLine();
        br.close();
        exe = exe.replaceAll("[\\*%@]", "").trim();
        String drive = exe.substring(0, 2) + "\\\\";
        String[] allparts = exe.split("(?=" + drive + ")");
        ArrayList<String> output = new ArrayList<String>();
        for (String allpart : allparts) {
            if (allpart.trim().length() == 0) continue;
            output.add(allpart.trim());
        }
        return output;
    }

    public static void checkExecutable() throws BazaarClientException {
        String exe = BazaarClientPreferences.getInstance().getString(BazaarPreference.EXECUTABLE);
        if (exe == null || "".equals(exe.trim())) {
            throw new BazaarClientException("Invalid bzr executable: '" + exe + "'");
        }
        if (exe.indexOf(File.separatorChar) >= 0) {
            File f = new File(exe);
            if (f.exists()) {
                return;
            }
            File fexe = new File(exe + ".exe");
            if (fexe.exists()) {
                return;
            }
            throw new BazaarClientException("There's no such file: " + exe);
        }
        try {
            if (BazaarUtilities.findExecutable().exists()) {
                return;
            }
        }
        catch (FileNotFoundException e) {
            throw BazaarClientException.wrapException(e);
        }
    }

    public static File findExecutable() throws FileNotFoundException {
        String path = System.getenv("PATH");
        return BazaarUtilities.findExecutable(path);
    }

    protected static File findExecutable(String path) throws FileNotFoundException {
        String[] parts;
        String[] executableNames = null;
        boolean isWindows = BazaarUtilities.isWindows();
        if (isWindows) {
            executableNames = new String[]{"bzr.exe", "bzr.bat"};
            return BazaarUtilities.findExecutableWin(executableNames, path);
        }
        executableNames = new String[]{"bzr"};
        for (String part : parts = path.split(File.pathSeparator)) {
            for (String executableName : executableNames) {
                File executable = new File(new File(part), executableName);
                if (!executable.canRead()) continue;
                return executable;
            }
        }
        throw new FileNotFoundException("bzr executable not found");
    }

    protected static File findExecutableWin(String[] exeNames, String path) throws FileNotFoundException {
        path = path + File.pathSeparator + System.getenv("PATHEXT");
        String delimiter = null;
        if (path != null) {
            StringTokenizer tokenizer = new StringTokenizer(path.replace("\\", "\\\\"), "" + File.pathSeparator);
            while (tokenizer.hasMoreElements()) {
                String _dir = tokenizer.nextToken();
                if (delimiter == null) {
                    delimiter = ", ";
                }
                File dir = new File(_dir);
                for (String exe : exeNames) {
                    File f = new File(dir, exe);
                    if (!f.exists()) continue;
                    return f;
                }
            }
        }
        StringBuilder exes = new StringBuilder();
        for (String exe : exeNames) {
            exes.append(exe).append(",");
        }
        throw new FileNotFoundException("Could not find any of: " + exes.toString() + " in PATH");
    }

    public static void configureBazaarClient(Class<? extends Object> clazz, String propertiesFile) {
        LOG.debug((Object)"Getting environment settings");
        BazaarClientPreferences prefs = BazaarClientPreferences.getInstance();
        try {
            InputStream is = clazz.getResourceAsStream(propertiesFile);
            Properties fileProps = new Properties();
            if (is != null) {
                fileProps.load(is);
                prefs.setFrom(fileProps);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading properties", (Throwable)e);
            throw BazaarClientException.makeUnChecked(e);
        }
        if (prefs.getString(BazaarPreference.EXECUTABLE) == null) {
            prefs.set(BazaarPreference.EXECUTABLE, "bzr");
        }
        LOG.debug((Object)"Initializing client factories");
        try {
            BazaarClientFactory.setupBestAvailableBackend(true);
        }
        catch (BazaarClientException e) {
            LOG.error((Object)"Error initializing client factories", (Throwable)e);
            throw BazaarClientException.makeUnChecked(e);
        }
    }

    public static void configureBazaarClient() {
        BazaarUtilities.configureBazaarClient(BazaarUtilities.class, "/tests.properties");
    }

    public static String[] getXmlOutputVersion() throws BazaarClientException {
        Plugins cmd = new Plugins();
        try {
            cmd.execute(new ShellCommandRunner());
            for (IPlugin plugin : new XMLPluginParser().parse(cmd.getStandardOutput())) {
                if (plugin.getName() == null || !plugin.getName().contains("xmloutput")) continue;
                return plugin.getVersion();
            }
        }
        catch (BazaarClientException e) {
            if (e.getMessage() != null && "xmlplugins".equals(e.getCommand()) && e.getMessage().contains("unknown command")) {
                throw new BazaarClientException("xmloutput plugin not found");
            }
            throw BazaarClientException.wrapException(e);
        }
        throw new BazaarClientException("xmloutput plugin not found");
    }
}

