/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.client.xmlrpc.internal;

import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.commandline.internal.CommandRunner;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.utils.StreamRedirect;
import org.vcs.bazaar.client.xmlrpc.XmlRpcCommandException;
import redstone.xmlrpc.XmlRpcArray;
import redstone.xmlrpc.XmlRpcClient;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRPCServer {
    private static final int MAX_RETRIES = 20;
    private static final int SLEEP_TIME = 200;
    private static final String START_XMLRPC = "start-xmlrpc";
    private static final String PORT_OPTION = "--port=";
    private static final String DEFAULT_PORT = "11111";
    private Process xmlRpcService;
    private final String port;
    private final BazaarClientPreferences preferences;
    private AtomicInteger runningCommands = new AtomicInteger(0);
    private AtomicInteger executionCount = new AtomicInteger(0);
    private static final Map<String, XMLRPCServer> INSTANCES = new ConcurrentHashMap<String, XMLRPCServer>();

    private XMLRPCServer(BazaarClientPreferences preferences, String port) {
        this.preferences = preferences;
        this.port = port;
        Runtime.getRuntime().addShutdownHook(new ServerKiller());
    }

    public synchronized void run() {
        try {
            if (this.testConnection()) {
                return;
            }
        }
        catch (XmlRpcCommandException e) {
            // empty catch block
        }
        this.destroyProcess();
        this.executionCount.set(0);
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(BazaarClientPreferences.getExecutable(true));
        args.add(START_XMLRPC);
        if (this.port != null && !"".equals(this.port)) {
            args.add(PORT_OPTION + this.port);
        }
        ProcessBuilder pb = this.createProcessBuilderWith(args);
        try {
            this.xmlRpcService = pb.start();
            StreamRedirect srout = new StreamRedirect("xmlrpc-service_stdout>null", this.xmlRpcService.getInputStream(), null);
            StringWriter serviceStdErr = new StringWriter();
            StreamRedirect srerr = new StreamRedirect("xmlrpc-service_stderr>null", this.xmlRpcService.getErrorStream(), serviceStdErr);
            srout.start();
            srerr.start();
            boolean connect = this.isConnected();
            for (int i = 0; i < 20 && !connect; ++i) {
                connect = this.isConnected();
                if (connect) continue;
                try {
                    this.xmlRpcService.exitValue();
                    this.xmlRpcService = null;
                    throw new BazaarClientException.BazaarUncheckedException(serviceStdErr.toString());
                }
                catch (IllegalThreadStateException e) {
                    Thread.sleep(200L);
                }
            }
            if (!connect) {
                throw new BazaarClientException.BazaarUncheckedException("Could not connect to XMLRPC server");
            }
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
        catch (InterruptedException intex) {
            throw new RuntimeException(intex);
        }
    }

    private boolean isConnected() throws InterruptedException {
        try {
            return this.testConnection();
        }
        catch (BazaarClientException ioex) {
            Thread.sleep(200L);
            return false;
        }
    }

    private boolean testConnection() throws XmlRpcCommandException {
        try {
            String result = (String)this.executeMethod("hello", new XmlRpcArray());
            return result != null && result.equals("world!");
        }
        catch (XmlRpcException e) {
            return false;
        }
    }

    private boolean isAlive() {
        try {
            if (!this.testConnection()) {
                if (this.xmlRpcService != null) {
                    this.xmlRpcService.exitValue();
                }
                return false;
            }
            return true;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
        catch (XmlRpcCommandException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(boolean force) {
        try {
            if (this.xmlRpcService != null || force) {
                this.executeMethod("quit", new XmlRpcArray());
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.destroyProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyProcess() {
        try {
            if (this.xmlRpcService != null) {
                this.xmlRpcService.destroy();
            }
        }
        finally {
            this.xmlRpcService = null;
        }
    }

    public Object executeMethod(String method, XmlRpcArray params) throws XmlRpcCommandException {
        try {
            return this.getClient(false).invoke(method, (List)params);
        }
        catch (XmlRpcFault e) {
            throw XmlRpcCommandException.wrapException((Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw XmlRpcCommandException.wrapException(e);
        }
    }

    public XmlRpcClient getClient(boolean secondary) throws MalformedURLException {
        String port = this.port;
        if (secondary) {
            port = String.valueOf(Integer.parseInt(port) + 1);
        }
        return new XmlRpcClient("http://127.0.0.1:" + port + "/RPC2", false);
    }

    public ProcessBuilder createProcessBuilderWith(List<String> args) {
        ProcessBuilder pb = new ProcessBuilder(args);
        CommandRunner.setDefaultEnviroment(pb, this.preferences);
        return pb;
    }

    public synchronized void checkStatus() {
        if (!this.isAlive()) {
            this.run();
        }
    }

    private int getRestartThreshold() {
        try {
            String t = this.preferences.getString(BazaarPreference.BZR_XMLRPC_RESTART_THRESHOLD);
            if (t != null) {
                return Integer.parseInt(t);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public synchronized void startCommand() {
        int restartThreshold = this.getRestartThreshold();
        if (restartThreshold > 0 && this.executionCount.incrementAndGet() > restartThreshold) {
            while (this.runningCommands.get() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            this.shutdown(true);
            for (int i = 0; i < 20; ++i) {
                try {
                    this.checkStatus();
                    break;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    continue;
                }
            }
            this.executionCount.addAndGet(-restartThreshold);
        }
        this.runningCommands.incrementAndGet();
    }

    public void endCommand() {
        this.runningCommands.decrementAndGet();
    }

    private static String getPort(BazaarClientPreferences preferences) {
        String p = preferences.getString(BazaarPreference.BZR_XMLRPC_PORT);
        if (p == null || p.isEmpty()) {
            p = DEFAULT_PORT;
        }
        return p;
    }

    public static synchronized XMLRPCServer getInstance(BazaarClientPreferences preferences) {
        String port = XMLRPCServer.getPort(preferences);
        XMLRPCServer server = INSTANCES.get(port);
        if (server == null) {
            server = new XMLRPCServer(preferences, port);
            INSTANCES.put(port, server);
        }
        return server;
    }

    class ServerKiller
    extends Thread {
        ServerKiller() {
        }

        public void run() {
            try {
                XMLRPCServer.this.shutdown(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

