/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc.serializers;

import java.io.IOException;
import java.io.Writer;
import redstone.xmlrpc.XmlRpcCustomSerializer;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcSerializer;

public class LongPrimitiveSerializer
implements XmlRpcCustomSerializer {
    private boolean useApacheExtension;

    public Class getSupportedClass() {
        return Long.TYPE;
    }

    public void setUseApacheExtension(boolean bl) {
        this.useApacheExtension = bl;
    }

    public void serialize(Object object, Writer writer, XmlRpcSerializer xmlRpcSerializer) throws XmlRpcException, IOException {
        Long l = (Long)object;
        if (!this.useApacheExtension) {
            writer.write("<i4>");
            writer.write(Integer.toString(l.intValue()));
            writer.write("</i4>");
        } else {
            writer.write("<value><i8 xmlns=\"http://ws.apache.org/xmlrpc/namespaces/extensions\">");
            writer.write(Long.toString(l));
            writer.write("</i8></value>");
        }
    }
}

