#!/usr/bin/env python
# -*- encoding: utf-8 -*-
#
# Copyright (C) 2013 Piotr Piastucki
#
# The code taken from bzrlib is under: Copyright (C) 2005-2007 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
#

"""modified conflicts command to generate xml output"""

import bzrlib
from bzrlib import errors
from bzrlib import workingtree
from writer import _escape_cdata

def conflicts_xml(outf, text=False, directory=u'.'):
    wt = workingtree.WorkingTree.open_containing(directory)[0]
    outf.write('<?xml version="1.0" encoding="%s"?>' % \
            bzrlib.osutils.get_user_encoding())
    outf.write('<conflicts>')
    for conflict in wt.conflicts():
        if text and conflict.typestring != 'text conflict':
            continue
        outf.write('<conflict><type>%s</type><path>%s</path><message>%s</message></conflict>' % (_escape_cdata(conflict.typestring), _escape_cdata(conflict.path), _escape_cdata(unicode(conflict))))
    outf.write('</conflicts>')
    

