#!/usr/bin/env python
# -*- encoding: utf-8 -*-
#
# Copyright (C) 2013 Piotr Piastucki
#
# The code taken from bzrlib is under: Copyright (C) 2005-2007 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
#

"""modified tags command to generate xml output"""

import bzrlib
from bzrlib import errors
from bzrlib.branch import Branch
from writer import _escape_cdata

# TODO: Handle revision
def show_tags_xml(outf, directory='.', sort=None, show_ids=False, revision=None, verbose=False):
    from bzrlib.tag import tag_sort_methods
    branch, relpath = Branch.open_containing(directory)

    tags = branch.tags.get_tag_dict().items()
    outf.write('<?xml version="1.0" encoding="%s"?>' % \
            bzrlib.osutils.get_user_encoding())
    outf.write('<tags>')
    if tags:
        branch.lock_read()
        try:
            if sort is None:
                sort = tag_sort_methods.get()
            sort(branch, tags)
            if not show_ids:
                # [ (tag, revid), ... ] -> [ (tag, dotted_revno), ... ]
                for index, (tag, revid) in enumerate(tags):
                    try:
                        revno = branch.revision_id_to_dotted_revno(revid)
                        if isinstance(revno, tuple):
                            revno = '.'.join(map(str, revno))
                    except (errors.NoSuchRevision,
                            errors.GhostRevisionsHaveNoRevno,
                            errors.UnsupportedOperation):
                        # Bad tag data/merges can lead to tagged revisions
                        # which are not in this branch. Fail gracefully ...
                        revno = '?'
                    tags[index] = (tag, revno)
            for tag, revspec in tags:
                outf.write('<tag><name>%s</name><revision>%s</revision></tag>' % (_escape_cdata(tag), _escape_cdata(revspec)))
        finally:
            branch.unlock()
    outf.write('</tags>')


