# -*- encoding: utf-8 -*-

import xmlrpclib
import threading

from bzrlib import (
    transport,
    tests,
    urlutils,
)
from bzrlib.tests.test_ftp_transport import TestCaseWithFTPServer

from bzrlib.plugins.xmloutput.service import BzrXMLRPCServer

class TestXmlRpcServerAuth(TestCaseWithFTPServer):

    def setUp(self):
        super(TestXmlRpcServerAuth, self).setUp()
        self.host = 'localhost'
        self.port = 0
        self._start_server()
        self.client = xmlrpclib.Server("http://%s:%s" % (self.host,
                                                         str(self.port)))
    def _start_server(self):
        self.xmlrpc_server =  BzrXMLRPCServer((self.host, self.port))
        self.thread = threading.Thread(target=self.xmlrpc_server.serve_forever)
        self.thread.setDaemon(True)
        self.thread.start()
        self.host, self.port = self.xmlrpc_server.socket.getsockname()
        # build an URL with a different username, so password it's prompted.
        base = self.get_url()
        parsed_url = transport.ConnectedTransport._split_url(base)
        new_url = parsed_url.clone()
        new_url.user = 'joe'
        new_url.quoted_user = urlutils.quote('joe')
        self.ftp_url = str(new_url)
        self.get_server().add_user('joe', 'joe-pass')

    def tearDown(self):
        self.client.quit()
        self.thread.join()
        super(TestXmlRpcServerAuth, self).tearDown()

    def test_hello(self):
        response = self.client.hello()
        self.assertEquals(response, "world!")

    def test_run_bzr_auth(self):
        self.disable_directory_isolation()
        exit, out, err = self.client.run_bzr_auth(['bzr', 'xmlplugins'], '.')
        self.assertEquals(exit, 0)
        self.assertEquals(err, "")
        self.assertNotEquals(out.data, "")

    def test_error_instead_of_hanging(self):
        self.disable_directory_isolation()
        exit, out, err = self.client.run_bzr(['bzr', 'xmlls', self.ftp_url], '.')
        self.assertNotEquals(exit, 0)
        self.assertContainsRe(err, "XMLRPC authentication password:")
        self.assertNotEquals(out.data, "")
        exit, out, err = self.client.run_bzr_auth(['bzr', 'xmlls', self.ftp_url], '.')
        self.assertNotEquals(exit, 0)
        self.assertContainsRe(err, "XMLRPC authentication password:")
        self.assertNotEquals(out.data, "")

    def test_successful_authentication_flow(self):
        self.disable_directory_isolation()
        exit, out, err = self.client.run_bzr(['bzr', 'xmlls', self.ftp_url], '.')
        self.assertNotEquals(exit, 0)
        self.assertContainsRe(err, "XMLRPC authentication password:")
        self.assertNotEquals(out.data, "")
        exit, out, err = self.client.run_bzr_auth(['bzr', 'xmlls', self.ftp_url], '.',\
                                                  'joe', 'joe-pass')
        self.assertNotEquals(exit, 0)
        self.assertContainsRe(err, "Not a branch")
        self.assertNotEquals(out.data, "")
