# -*- encoding: utf-8 -*-

import xmlrpclib
import threading

from bzrlib import (
    tests,
    ui
    )
from bzrlib.plugins.xmloutput.service import *
from bzrlib.plugins.xmloutput.uifactory import current_progress

class TestXmlRpcServer(tests.TestCase):

    def setUp(self):
        tests.TestCase.setUp(self)
        self.host = 'localhost'
        self.port = 0
        self._start_server()
        self.client = xmlrpclib.Server("http://%s:%s" % (self.host,
                                                         str(self.port)))

    def _start_server(self):
        os.environ['BZR_PROGRESS_BAR'] = 'xmlrpc'
        self.server =  BzrXMLRPCServer((self.host, self.port))
        self.thread = threading.Thread(target=self.server.serve_forever)
        self.thread.setDaemon(True)
        self.thread.start()
        self.host, self.port = self.server.socket.getsockname()

    def tearDown(self):
        response = self.client.quit()
        self.thread.join()
        tests.TestCase.tearDown(self)

    def test_hello(self):
        response = self.client.hello()
        self.assertEquals(response, "world!")

    def test_get_bzr_progress(self):
        global current_progress
        client = xmlrpclib.Server("http://%s:%s" % (self.host, str(self.port + 1)))
        current_progress['TEST'] = '123'
        cmdline = []
        cmdline.append('TEST')
        progress = client.get_bzr_progress(cmdline)
        self.assertEquals(progress, '123')

