# -*- encoding: utf-8 -*-

import sys
from bzrlib import (
    tests,
    ui,
    )
from bzrlib.plugins.xmloutput.uifactory import AuthenticatingUIFactory

class TestAuthenticatingUIFactory(tests.TestCase):

    def test_error_throwing(self):
        uif = AuthenticatingUIFactory(sys.stdin, sys.stdout, sys.stderr)
        self.assertRaises(ValueError, uif.get_username, ('login'))
        self.assertRaises(ValueError, uif.get_password, ('password'))

    def test_canned_values(self):
        uif = AuthenticatingUIFactory(sys.stdin, sys.stdout, sys.stderr, username='user123', password='pass123')
        t = uif.get_username('login')
        self.assertEquals(t, 'user123')
        t = uif.get_password('password')
        self.assertEquals(t, 'pass123')

