#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013 Piotr Piastucki
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

from bzrlib.ui.text import TextUIFactory
from bzrlib.ui.text import TextProgressView
from bzrlib.ui import NullProgressView
from cStringIO import StringIO

current_progress = {}

class AuthenticatingUIFactory(TextUIFactory):

    def __init__(self,
                 stdin=None,
                 stdout=None,
                 stderr=None,
                 username=None,
                 password=None,
                 argv=None):
        if argv is not None:
            self.cmd_id = '|'.join(argv)
        else:
            self.cmd_id = ''
        super(AuthenticatingUIFactory, self).__init__(stdin, stdout, stderr)
        self.username = username
        self.password = password

    def get_prompt_text(self, prompt=u'', **kwargs):
        if type(prompt) != unicode:
            raise ValueError("prompt %r not a unicode string" % prompt)
        if kwargs:
            prompt = prompt % kwargs
        return prompt

    def get_password(self, prompt=u'', **kwargs):
        if self.password is None:
            raise ValueError('XMLRPC authentication password:' + self.get_prompt_text(prompt, **kwargs))
        return self.password

    def get_username(self, prompt, **kwargs):
        if self.username is None:
            raise ValueError('XMLRPC authentication username:' + self.get_prompt_text(prompt, **kwargs))
        return self.username

    def make_progress_view(self):
        return XmlRpcProgressView(self.cmd_id)

class XmlRpcProgressView(TextProgressView):

    def __init__(self, cmd_id):
        self.cmd_id = cmd_id
        super(XmlRpcProgressView, self).__init__(StringIO())

    def _show_line(self, u):
        global current_progress
        #s = u.encode(self._encoding, self._encoding_errors)
        current_progress.clear()
        current_progress[self.cmd_id] = u

