/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.RepositoryProvider;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalFile;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalFolder;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider;
import org.vcs.bazaar.eclipse.core.repository.BranchFactory;
import org.vcs.bazaar.eclipse.core.utils.BzrTeamStatus;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;
import org.vcs.bazaar.eclipse.internal.core.model.ProjectBranch;
import org.vcs.bazaar.eclipse.internal.core.model.local.BzrLocalFile;
import org.vcs.bazaar.eclipse.internal.core.model.local.BzrLocalFolder;

public class BzrWorkspaceRoot {
    private static final Map<IBzrBranch, IBazaarClient> CLIENTS = new ConcurrentHashMap<IBzrBranch, IBazaarClient>();
    private static final Map<IBzrBranch, IBazaarClient> NO_LOGS_CLIENTS = new ConcurrentHashMap<IBzrBranch, IBazaarClient>();
    private IBzrLocalBranch branch;

    public BzrWorkspaceRoot(IProject project) {
        this.branch = BranchFactory.findOrCreateFor(project);
        try {
            this.ensureMetaFolderIsTeamPrivate(project);
        }
        catch (CoreException e) {
            EclipseBazaarCore.log(e.getMessage(), e);
        }
    }

    public static IPath pathForLocation(IPath location) {
        if (Platform.getLocation().equals((Object)location)) {
            return Path.ROOT;
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IPath projectLocation = project.getLocation();
            if (projectLocation != null && projectLocation.isPrefixOf(location)) {
                int segmentsToRemove = projectLocation.segmentCount();
                return project.getFullPath().append(location.removeFirstSegments(segmentsToRemove));
            }
            ++i;
        }
        return null;
    }

    public static IBzrLocalFile getBzrFileFor(IResource resource) {
        ProjectBranch branch = BranchFactory.findOrCreateFor(resource.getProject());
        return new BzrLocalFile(resource, branch);
    }

    public static IBzrLocalFolder getBzrFolderFor(IContainer resource) {
        ProjectBranch branch = BranchFactory.findOrCreateFor(resource.getProject());
        return new BzrLocalFolder(resource, (IBzrBranch)branch);
    }

    public static IBzrLocalResource getBzrResourceFor(IResource resource) {
        if (resource.getType() == 1) {
            return BzrWorkspaceRoot.getBzrFileFor(resource);
        }
        return BzrWorkspaceRoot.getBzrFolderFor((IContainer)resource);
    }

    public static IBzrLocalResource[] getBzrResourcesFor(IResource[] resources) {
        IBzrLocalResource[] bzrResources = new IBzrLocalResource[resources.length];
        int i = 0;
        while (i < resources.length) {
            bzrResources[i] = BzrWorkspaceRoot.getBzrResourceFor(resources[i]);
            ++i;
        }
        return bzrResources;
    }

    public IBzrLocalBranch getBranch() {
        return this.branch;
    }

    public static BzrWorkspaceRoot getBzrWorkspaceRootFor(IProject project) {
        BazaarTeamProvider provider = BzrWorkspaceRoot.getProviderFor(project);
        if (provider == null) {
            return null;
        }
        return provider.getBzrWorkspaceRoot();
    }

    public static BazaarTeamProvider getProviderFor(IProject project) {
        BazaarTeamProvider provider = (BazaarTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)EclipseBazaarCore.getProviderID());
        return provider;
    }

    public static IBzrLocalBranch getBranchFor(IProject project) {
        BazaarTeamProvider provider = BzrWorkspaceRoot.getProviderFor(project);
        if (provider == null) {
            return null;
        }
        return provider.getBzrWorkspaceRoot().getBranch();
    }

    public IBazaarClient getClient() throws BazaarException {
        return BzrWorkspaceRoot.getClient(this.branch);
    }

    public IBazaarClient getClient(boolean disableLogs) throws BazaarException {
        return BzrWorkspaceRoot.getClient(this.branch, disableLogs);
    }

    public static IBazaarClient getClient(IBzrBranch branch) throws BazaarException {
        return BzrWorkspaceRoot.getClient(branch, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IBazaarClient getClient(IBzrBranch branch, boolean disableLogs) throws BazaarException {
        Map<IBzrBranch, IBazaarClient> clients = disableLogs ? NO_LOGS_CLIENTS : CLIENTS;
        IBazaarClient client = clients.get(branch);
        if (client == null) {
            Map<IBzrBranch, IBazaarClient> map = clients;
            synchronized (map) {
                client = clients.get(branch);
                if (client == null) {
                    try {
                        client = EclipseBazaarCore.getDefault().createClient();
                        if (branch.isLocal()) {
                            client.setWorkDir(branch.getFile());
                        }
                        if (disableLogs) {
                            client.getNotificationHandler().disableLog();
                        }
                        clients.put(branch, client);
                        return client;
                    }
                    catch (BazaarException e) {
                        if (!EclipseBazaarCore.getDefault().isClientAvailable()) {
                            throw new BazaarException(new BzrTeamStatus(4, "Bazaar client not available." + System.getProperty("line.separator") + " Please check the bazaar and bzr-xmloutput plugin installation", (Throwable)((Object)e)));
                        }
                        throw e;
                    }
                }
            }
        }
        return client;
    }

    private void ensureMetaFolderIsTeamPrivate(IProject project) throws CoreException {
        if (project != null) {
            IResource metaFolder = project.findMember((IPath)new Path(".bzr"));
            if (metaFolder != null && metaFolder.exists()) {
                metaFolder.setTeamPrivateMember(true);
            }
            if ((metaFolder = project.findMember((IPath)new Path(".bzr.backup"))) != null && metaFolder.exists()) {
                metaFolder.setTeamPrivateMember(true);
            }
        }
    }

    public static IProject[] findProjectsInBranch(IResource resource) {
        IProject project = resource.getProject();
        IBzrBranch branch = BzrWorkspaceRoot.getProviderFor(project).getBranch();
        return BzrWorkspaceRoot.findProjectsInBranch(branch);
    }

    public static IProject[] findProjectsInBranch(IBzrBranch branch) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            BazaarTeamProvider provider;
            IProject p = iProjectArray[n2];
            if (p.isAccessible() && (provider = BzrWorkspaceRoot.getProviderFor(p)) != null && branch.equals(provider.getBranch())) {
                projects.add(p);
            }
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    public static void purgeClients() {
        CLIENTS.clear();
        NO_LOGS_CLIENTS.clear();
    }

    public static boolean isLightweightCheckout(IProject project) {
        File metaFolder;
        File branchFolder;
        File locationFile;
        IPath location = ResourceUtil.findRootLocation(project);
        boolean lightweight = false;
        if (location != null && (locationFile = new File(branchFolder = new File(metaFolder = new File(location.toFile(), ".bzr"), "branch"), "location")).exists()) {
            lightweight = true;
        }
        return lightweight;
    }
}

