/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarNotifyListener;
import org.vcs.bazaar.client.IBazaarPromptUserPassword;
import org.vcs.bazaar.client.IPlugin;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.xmlrpc.XmlRpcClient;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.ClientProperties;
import org.vcs.bazaar.eclipse.core.BzrSaveParticipant;
import org.vcs.bazaar.eclipse.core.client.DelegatingConsoleListener;
import org.vcs.bazaar.eclipse.core.credentials.DelegatingCredentialsProvider;
import org.vcs.bazaar.eclipse.core.credentials.SecureCredentialsStore;
import org.vcs.bazaar.eclipse.core.listeners.AbstractResourceChangeListener;
import org.vcs.bazaar.eclipse.core.listeners.BzrChangeStateEvent;
import org.vcs.bazaar.eclipse.core.listeners.FileModificationManager;
import org.vcs.bazaar.eclipse.core.listeners.IResourceStateListener;
import org.vcs.bazaar.eclipse.core.listeners.SyncFileChangeListener;
import org.vcs.bazaar.eclipse.core.log.LogCacheManager;
import org.vcs.bazaar.eclipse.core.notifications.DelegatingNotificationListener;
import org.vcs.bazaar.eclipse.core.notifications.Notification;
import org.vcs.bazaar.eclipse.core.notifications.NotificationListener;
import org.vcs.bazaar.eclipse.core.status.StatusCacheManager;
import org.vcs.bazaar.eclipse.core.utils.PreferenceHelper;
import org.vcs.bazaar.eclipse.core.utils.TracingUtils;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class EclipseBazaarCore
extends Plugin {
    private static final String UNIX_DISABLE_LOGS = "/dev/null";
    private static final String WINDOWS_DISABLE_LOGS = "NUL";
    public static final String ID = "org.vcs.bazaar.eclipse.core";
    private static EclipseBazaarCore plugin;
    private static final List<IResourceStateListener> stateListeners;
    private StatusCacheManager statusCacheManager;
    private LogCacheManager logCacheManager;
    private final AbstractResourceChangeListener fileModificationManager = new FileModificationManager();
    private final AbstractResourceChangeListener metaDirChangeListener = new SyncFileChangeListener();
    private boolean clientAvailable = false;
    private Set<IPlugin> bzrPlugins;
    private SecureCredentialsStore secureCredentialsStore;
    private DelegatingCredentialsProvider credentialsProvider = new DelegatingCredentialsProvider();
    private DelegatingConsoleListener consoleListener = new DelegatingConsoleListener();
    private DelegatingNotificationListener notificationListener = new DelegatingNotificationListener();

    static {
        stateListeners = new ArrayList<IResourceStateListener>();
    }

    public EclipseBazaarCore() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.statusCacheManager = new StatusCacheManager();
        this.logCacheManager = new LogCacheManager();
        this.secureCredentialsStore = new SecureCredentialsStore();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fileModificationManager, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.metaDirChangeListener, 1);
        ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)new BzrSaveParticipant());
        try {
            this.checkClient();
        }
        catch (BazaarException e) {
            EclipseBazaarCore.log((CoreException)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fileModificationManager);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.metaDirChangeListener);
        List<IResourceStateListener> list = stateListeners;
        synchronized (list) {
            stateListeners.clear();
        }
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)this);
        super.stop(context);
        plugin = null;
    }

    public static EclipseBazaarCore getDefault() {
        return plugin;
    }

    public static final String getPluginId() {
        return ID;
    }

    public static String getProviderID() {
        return "org.vcs.bazaar.eclipse.core.repository.BazaarTeamProvider";
    }

    public IBazaarClient createClient() throws BazaarException {
        boolean checkPlugins = this.bzrPlugins == null || !this.clientAvailable;
        this.checkClient();
        try {
            IBazaarClient client = BazaarClientFactory.createClient((String)BazaarClientFactory.getPreferredClientType());
            if (client != null) {
                if (checkPlugins) {
                    try {
                        this.bzrPlugins = client.plugins();
                    }
                    catch (Exception exception) {}
                }
                client.addNotifyListener((IBazaarNotifyListener)this.consoleListener);
                client.addPasswordCallback((IBazaarPromptUserPassword)this.credentialsProvider);
            }
            return client;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        catch (BazaarClientException.BazaarUncheckedException e) {
            EclipseBazaarCore.log(e.getMessage(), e);
            throw BazaarException.wrapException((Exception)((Object)e));
        }
    }

    public void checkClient() throws BazaarException {
        if (!this.clientAvailable) {
            String executable = PreferenceHelper.get(BazaarPreference.EXECUTABLE.name());
            String email = null;
            if (PreferenceHelper.getBoolean("pref_overwrite_email")) {
                email = PreferenceHelper.get(BazaarPreference.BZR_EMAIL.name());
            }
            String port = PreferenceHelper.get(BazaarPreference.BZR_XMLRPC_PORT.name());
            boolean disableLogs = PreferenceHelper.getBoolean("disable_logs");
            this.checkClient(this.getClientProperties(executable, email, port, disableLogs));
        }
    }

    public void checkClient(ClientProperties props) throws BazaarException {
        this.updateClientPreferences(props);
        try {
            BazaarClientFactory.setupBestAvailableBackend((boolean)true);
            this.clientAvailable = true;
        }
        catch (BazaarClientException e) {
            this.clientAvailable = false;
            throw BazaarException.wrapException(e);
        }
    }

    public String[] getAvailableClientTypes() {
        return BazaarClientFactory.getClientTypes();
    }

    public boolean isClientAvailable() {
        return this.clientAvailable;
    }

    public void setConsoleListener(IBazaarNotifyListener listener) {
        this.consoleListener.setConsoleListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceStateListener(IResourceStateListener listener) {
        List<IResourceStateListener> list = stateListeners;
        synchronized (list) {
            if (!stateListeners.contains(listener)) {
                stateListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResourceStateListener(IResourceStateListener listener) {
        List<IResourceStateListener> list = stateListeners;
        synchronized (list) {
            stateListeners.remove(listener);
        }
    }

    public StatusCacheManager getStatusCacheManager() {
        return this.statusCacheManager;
    }

    public LogCacheManager getLogCacheManager() {
        return this.logCacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void broadcastModificationStateChanges(final BzrChangeStateEvent event) {
        IResourceStateListener[] toNotify;
        EclipseBazaarCore.trace("", "broadcastModificationStateChanges: ", event);
        List<IResourceStateListener> list = stateListeners;
        synchronized (list) {
            toNotify = stateListeners.toArray(new IResourceStateListener[stateListeners.size()]);
        }
        int i = 0;
        while (i < toNotify.length) {
            final IResourceStateListener listener = toNotify[i];
            ISafeRunnable code = new ISafeRunnable(){

                public void run() throws Exception {
                    listener.resourceStateChanged(event);
                }

                public void handleException(Throwable e) {
                }
            };
            SafeRunner.run((ISafeRunnable)code);
            ++i;
        }
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor subProgressMonitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        return new SubProgressMonitor(monitor, 1000);
    }

    public static void log(String message, int severity) {
        Status status = new Status(severity, EclipseBazaarCore.getPluginId(), 0, message, null);
        EclipseBazaarCore.getDefault().getLog().log((IStatus)status);
    }

    public static void log(String message, Throwable thr) {
        Status status = new Status(4, EclipseBazaarCore.getPluginId(), 0, message, thr);
        EclipseBazaarCore.getDefault().getLog().log((IStatus)status);
    }

    public static void log(CoreException ce) {
        EclipseBazaarCore.getDefault().getLog().log(ce.getStatus());
    }

    public static boolean isTracing(String optionId) {
        String option = String.valueOf(EclipseBazaarCore.getPluginId()) + "/trace/" + optionId;
        String value = Platform.getDebugOption((String)option);
        return "true".equals(value);
    }

    public static void trace(String optionId, String what, Object ... objects) {
        if (EclipseBazaarCore.isTracing(optionId)) {
            TracingUtils.trace(what, objects);
        }
    }

    public static void traceException(String optionId, Exception ex) {
        if (EclipseBazaarCore.isTracing(optionId)) {
            TracingUtils.trace("", ex);
        }
    }

    public IPlugin getPlugin(String pluginName) {
        if (this.clientAvailable && this.bzrPlugins != null) {
            for (IPlugin plugin : this.bzrPlugins) {
                if (!pluginName.equals(plugin.getName())) continue;
                return plugin;
            }
        }
        return null;
    }

    public SecureCredentialsStore getSecureCredentialsStore() {
        return this.secureCredentialsStore;
    }

    public void setCredentialsProvider(IBazaarPromptUserPassword provider) {
        this.credentialsProvider.setCredentialsProvider(provider);
    }

    public void setNotificationListener(NotificationListener listener) {
        this.notificationListener.setNotificationListener(listener);
    }

    protected static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    protected ClientProperties getCurrentClientProperties() {
        BazaarClientPreferences clientPreferences = this.getClientPreferences();
        String executable = clientPreferences.getString(BazaarPreference.EXECUTABLE);
        String email = clientPreferences.getString(BazaarPreference.BZR_EMAIL);
        String port = clientPreferences.getString(BazaarPreference.BZR_XMLRPC_PORT);
        String logs = clientPreferences.getString(BazaarPreference.BZR_LOG);
        boolean disableLogs = false;
        disableLogs = EclipseBazaarCore.isWindows() ? WINDOWS_DISABLE_LOGS.equals(logs) : UNIX_DISABLE_LOGS.equals(logs);
        return new ClientProperties(executable, email, port, disableLogs);
    }

    public ClientProperties getClientProperties(String executable, String email, String port, boolean disableLogs) {
        if (executable == null || executable.trim().isEmpty()) {
            executable = this.getClientPreferences().getAutodetectedExecutable();
        }
        return new ClientProperties(executable, email, port, disableLogs);
    }

    private void updateClientPreferences(ClientProperties properties) {
        if (!this.getCurrentClientProperties().equals(properties)) {
            this.stopClient();
            BazaarClientPreferences clientPreferences = this.getClientPreferences();
            clientPreferences.set(BazaarPreference.EXECUTABLE, properties.getExecutable());
            if (properties.getEmail() != null && !properties.getEmail().trim().isEmpty()) {
                clientPreferences.set(BazaarPreference.BZR_EMAIL, properties.getEmail());
            } else {
                clientPreferences.unset(BazaarPreference.BZR_EMAIL);
            }
            clientPreferences.set(BazaarPreference.BZR_XMLRPC_PORT, properties.getPort());
            clientPreferences.set(BazaarPreference.BZR_PLUGIN_PATH, this.getBundledPluginsPath());
            if (properties.isDisableLogs()) {
                clientPreferences.set(BazaarPreference.BZR_LOG, EclipseBazaarCore.isWindows() ? WINDOWS_DISABLE_LOGS : UNIX_DISABLE_LOGS);
            } else {
                clientPreferences.unset(BazaarPreference.BZR_LOG);
            }
        }
    }

    private void stopClient() {
        if (this.clientAvailable) {
            try {
                IBazaarClient client = BazaarClientFactory.createClient((String)BazaarClientFactory.getPreferredClientType());
                if (client instanceof XmlRpcClient) {
                    ((XmlRpcClient)client).stopXmlRpcService();
                }
            }
            catch (BazaarClientException e) {
                EclipseBazaarCore.log(e.getMessage(), e);
            }
            catch (BazaarClientException.BazaarUncheckedException e) {
                EclipseBazaarCore.log(e.getMessage(), e);
            }
            BzrWorkspaceRoot.purgeClients();
            this.clientAvailable = false;
        }
    }

    private BazaarClientPreferences getClientPreferences() {
        return BazaarClientPreferences.getInstance();
    }

    public String getBundledPluginsPath() {
        Bundle clientBundle = null;
        Bundle[] bundleArray = this.getBundle().getBundleContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ("org.vcs.bazaar.eclipse.client".equals(bundle.getSymbolicName().trim())) {
                clientBundle = bundle;
                break;
            }
            ++n2;
        }
        try {
            URL entry = FileLocator.resolve((URL)FileLocator.findEntries(clientBundle, (IPath)new Path("plugins"))[0]);
            return new File(entry.getPath()).getPath();
        }
        catch (IOException e) {
            Status status = new Status(4, ((Object)((Object)this)).getClass().getPackage().getName(), e.getMessage(), (Throwable)e);
            this.getLog().log((IStatus)status);
            return null;
        }
    }

    public void sendNotification(Notification notification) {
        this.notificationListener.message(notification);
    }
}

