/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.vcs.bazaar.client.BazaarClientFactory;
import org.vcs.bazaar.client.BazaarClientPreferences;
import org.vcs.bazaar.client.BazaarPreference;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    private String whoami() {
        try {
            BazaarClientPreferences.getInstance().set(BazaarPreference.BZR_PLUGIN_PATH, EclipseBazaarCore.getDefault().getBundledPluginsPath());
            IBazaarClient client = BazaarClientFactory.createClient((String)"CommandLine");
            return client.whoami(new Option[0]);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences p = new DefaultScope().getNode(EclipseBazaarCore.getPluginId());
        p.putBoolean("pref_overwrite_email", true);
        p.putBoolean("disable_logs", false);
        p.putInt("pref_performance_log_limit", 200);
        p.put(BazaarPreference.EXECUTABLE.name(), BazaarClientPreferences.getInstance().getString(BazaarPreference.EXECUTABLE));
        String name = this.whoami();
        p.put(BazaarPreference.BZR_EMAIL.name(), name.isEmpty() ? System.getProperty("user.name") : name);
        p.putInt(BazaarPreference.BZR_XMLRPC_PORT.name(), 11111);
    }
}

