/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.ResourceChangeCommand;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCommand
extends ResourceChangeCommand {
    private final List<? extends IResource> resources;
    private final BzrWorkspaceRoot root;

    public AddCommand(BzrWorkspaceRoot bzrWorkspaceRoot, List<? extends IResource> resources) {
        this.root = bzrWorkspaceRoot;
        this.resources = resources;
    }

    @Override
    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            this.root.getClient().add(AddCommand.getFiles(this.resources), this.getOptions());
            return BzrWorkspaceRoot.findProjectsInBranch(this.root.getBranch());
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
    }

    private static File[] getFiles(List<? extends IResource> resources) {
        File[] files = new File[resources.size()];
        int i = 0;
        while (i < resources.size()) {
            files[i] = resources.get(i).getLocation().toFile();
            ++i;
        }
        return files;
    }
}

