/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarAnnotation;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class AnnotateCommand
extends BazaarCommand {
    private final IBzrLocalResource resource;
    private IBazaarAnnotation annotation;

    public AnnotateCommand(IBzrLocalResource bzrResource) {
        this.resource = bzrResource;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask(CoreTexts.AnnotateCommand_annotate, 1000);
                monitor.setTaskName(CoreTexts.AnnotateCommand_annotate);
                IBazaarClient client = AnnotateCommand.getClient(this.resource.getIResource().getProject());
                this.annotation = client.annotate(this.resource.getIResource().getLocation().toFile(), this.getOptions());
                monitor.worked(1000);
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e, this.resource.getIResource());
            }
        }
        finally {
            monitor.done();
        }
    }

    public IBazaarAnnotation getAnnotation() {
        return this.annotation;
    }
}

