/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.core.commands.IBazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.core.utils.PreferenceHelper;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BazaarCommand
implements IBazaarCommand {
    private Option[] options = null;

    protected static final Map<IProject, List<File>> getFilesByProjectMap(IBzrLocalResource[] resources) {
        HashMap<IProject, List<File>> map = new HashMap<IProject, List<File>>();
        IBzrLocalResource[] iBzrLocalResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IBzrLocalResource bzrResource = iBzrLocalResourceArray[n2];
            IProject project = bzrResource.getIResource().getProject();
            ArrayList<File> list = (ArrayList<File>)map.get(project);
            if (list == null) {
                list = new ArrayList<File>();
                map.put(project, list);
            }
            list.add(bzrResource.getIResource().getLocation().toFile());
            ++n2;
        }
        return map;
    }

    protected static final Map<IBzrBranch, List<File>> getFilesByBranchMap(List<IBzrLocalResource> resources) {
        return BazaarCommand.getFilesByBranchMap(resources.toArray(new IBzrLocalResource[0]));
    }

    protected static final Map<IBzrBranch, List<File>> getFilesByBranchMap(IBzrLocalResource[] resources) {
        HashMap<IBzrBranch, List<File>> map = new HashMap<IBzrBranch, List<File>>();
        IBzrLocalResource[] iBzrLocalResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IBzrLocalResource bzrResource = iBzrLocalResourceArray[n2];
            IBzrBranch branch = bzrResource.getBranch();
            ArrayList<File> list = (ArrayList<File>)map.get(branch);
            if (list == null) {
                list = new ArrayList<File>();
                map.put(branch, list);
            }
            list.add(bzrResource.getFile());
            ++n2;
        }
        return map;
    }

    protected static Map<IBzrBranch, List<IProject>> getProjectsByBranch(IProject[] projects) {
        HashMap<IBzrBranch, List<IProject>> map = new HashMap<IBzrBranch, List<IProject>>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IBzrLocalBranch branch = BzrWorkspaceRoot.getBranchFor(project);
            ArrayList<IProject> list = (ArrayList<IProject>)map.get(branch);
            if (list == null) {
                list = new ArrayList<IProject>();
                map.put(branch, list);
            }
            list.add(project);
            ++n2;
        }
        return map;
    }

    protected static final IBazaarClient getClient(IProject project) throws BazaarException {
        return BzrWorkspaceRoot.getBzrWorkspaceRootFor(project).getClient();
    }

    protected static final IBazaarClient getClient(IProject project, boolean disableLogs) throws BazaarException {
        return BzrWorkspaceRoot.getBzrWorkspaceRootFor(project).getClient(disableLogs);
    }

    protected static final IBazaarClient getClient(IBzrBranch branch) throws BazaarException {
        return BzrWorkspaceRoot.getClient(branch);
    }

    protected static final IBazaarClient getClient(IBzrBranch branch, boolean disableLogs) throws BazaarException {
        return BzrWorkspaceRoot.getClient(branch, disableLogs);
    }

    protected static final List<File> getFiles(Collection<IBzrLocalResource> resources) {
        ArrayList<File> list = new ArrayList<File>();
        for (IBzrLocalResource bzrResource : resources) {
            list.add(bzrResource.getFile());
        }
        return list;
    }

    public Option[] getOptions() {
        if (this.options == null) {
            if (PreferenceHelper.getBoolean("ignore_ssl_errors")) {
                this.options = new Option[1];
                this.options[0] = new Option("-Ossl.cert_reqs=none");
            } else {
                this.options = new Option[0];
            }
        }
        return this.options;
    }

    public void addOptions(Option ... moreO) {
        this.getOptions();
        Option[] newO = Arrays.copyOf(this.options, this.options.length + moreO.length);
        int i = 0;
        while (i < moreO.length) {
            newO[this.options.length + i] = moreO[i];
            ++i;
        }
        this.options = newO;
    }

    @Override
    public abstract void run(IProgressMonitor var1) throws BazaarException;
}

