/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.StateChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class BindCommand
extends StateChangeCommand {
    private IBzrBranch branch;
    private BranchLocation location;

    public BindCommand(IBzrBranch branch, BranchLocation location) {
        this.branch = branch;
        this.location = location;
    }

    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        try {
            monitor.beginTask(CoreTexts.BindCommand_taskName, 1000);
            IBazaarClient client = BindCommand.getClient(this.branch);
            monitor.worked(500);
            client.bind(this.location, this.getOptions());
            IProject[] iProjectArray = BzrWorkspaceRoot.findProjectsInBranch(this.branch);
            return iProjectArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }
}

