/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarProgressListener;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.EclipseBazaarCore;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.commands.CommandProgressListener;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.utils.ResourceUtil;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class BranchCommand
extends BazaarCommand {
    private final IBzrBranch remoteLocation;
    private BazaarRevision revision;
    private final File toLocation;

    public BranchCommand(IBzrBranch sourceLocation, File toLocation, String revision, Option ... options) {
        this.remoteLocation = sourceLocation;
        this.toLocation = toLocation;
        this.addOptions(options);
        if (revision != null && revision.trim().length() != 0) {
            try {
                this.setRevision(BazaarRevision.getRevision((BazaarRevision.Prefix)BazaarRevision.Prefix.REVNO, (String)revision));
            }
            catch (BazaarClientException.BazaarUncheckedException e) {
                EclipseBazaarCore.log(e.getMessage(), e);
                this.setRevision(null);
            }
        }
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask("", 100);
                IBazaarClient client = EclipseBazaarCore.getDefault().createClient();
                client.setWorkDir(this.getToLocation());
                this.runOnClient(client, new CommandProgressListener(monitor));
            }
            catch (BazaarClientException e) {
                EclipseBazaarCore.log(e.getMessage(), e);
                ResourceUtil.deleteRecursively(this.getToLocation());
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.setTaskName("");
            monitor.done();
        }
    }

    protected void runOnClient(IBazaarClient client, CommandProgressListener cpl) throws BazaarClientException {
        client.branch(this.getRemoteLocation(), this.getToLocation(), (IBazaarRevisionSpec)this.getRevision(), (IBazaarProgressListener)cpl, this.getOptions());
    }

    protected File getToLocation() {
        return this.toLocation;
    }

    protected void setRevision(BazaarRevision revision) {
        this.revision = revision;
    }

    protected BazaarRevision getRevision() {
        return this.revision;
    }

    protected BranchLocation getRemoteLocation() {
        return this.remoteLocation.getBranchLocation();
    }
}

