/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.BazaarRevision;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarRevisionSpec;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.client.core.BranchLocation;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

public class CatCommand
extends BazaarCommand {
    private IBzrBranch branch;
    private File file;
    private BranchLocation location;
    private BazaarRevision revision;
    private InputStream content;
    private String charsetName;

    public CatCommand(IBzrBranch branch, File file, String charsetName, BazaarRevision revision) {
        this.branch = branch;
        this.file = file;
        this.revision = revision;
        this.charsetName = charsetName;
    }

    public CatCommand(IBzrBranch branch, BranchLocation location, String charsetName, BazaarRevision revision) {
        this.branch = branch;
        this.location = location;
        this.revision = revision;
        this.charsetName = charsetName;
    }

    public void run(IProgressMonitor monitor) throws BazaarException {
        block7: {
            try {
                try {
                    monitor.beginTask(CoreTexts.CatCommand_taskName, 1000);
                    IBazaarClient client = CatCommand.getClient(this.branch, true);
                    if (this.file != null) {
                        this.content = client.cat(this.file, (IBazaarRevisionSpec)this.revision, this.charsetName, this.getOptions());
                        break block7;
                    }
                    this.content = client.cat(this.location, (IBazaarRevisionSpec)this.revision, this.charsetName, this.getOptions());
                }
                catch (BazaarClientException e) {
                    if (e.getMessage() == null || !e.getMessage().contains("is not present in revision")) {
                        throw BazaarException.wrapException(e);
                    }
                    this.content = new ByteArrayInputStream(new byte[0]);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public InputStream getContent() {
        return this.content;
    }
}

