/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarProgressListener;

public class CommandProgressListener
implements IBazaarProgressListener {
    protected final IProgressMonitor monitor;
    protected int worked;
    protected int maxtotal;
    Pattern FETCHING_REVISIONS_PATTERN = Pattern.compile(".*?Fetching revisions:Inserting stream:Estimate.*?(\\d+)/(\\d+)");

    public CommandProgressListener(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void logProgress(String message) {
        if (this.monitor != null) {
            Matcher m;
            if (message != null && (m = this.FETCHING_REVISIONS_PATTERN.matcher(message)).matches()) {
                int w;
                int newWorked = 0;
                if (this.worked == 0) {
                    newWorked = 5;
                }
                int completedWork = Integer.parseInt(m.group(1));
                int totalWork = Integer.parseInt(m.group(2));
                if (totalWork > this.maxtotal) {
                    this.maxtotal = totalWork;
                } else if (this.maxtotal > 0 && (w = 5 + completedWork * 95 / this.maxtotal) > newWorked) {
                    newWorked = w;
                }
                if (newWorked > this.worked) {
                    this.monitor.worked(newWorked - this.worked);
                    this.worked = newWorked;
                }
            }
            this.monitor.setTaskName(message);
        }
    }
}

