/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.commandline.commands.options.Option;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.BzrWorkspaceRoot;
import org.vcs.bazaar.eclipse.CoreTexts;
import org.vcs.bazaar.eclipse.core.commands.StateChangeCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.core.model.local.IBzrLocalResource;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitCommand
extends StateChangeCommand {
    private String commitMessage;
    private List<IBzrLocalResource> resources;
    private boolean fullCommit;
    private boolean fullRefresh;

    public CommitCommand(List<IBzrLocalResource> filesToCommit, String commitMessage, Option ... options) {
        this.resources = filesToCommit;
        this.commitMessage = commitMessage;
        this.addOptions(options);
    }

    public CommitCommand(List<IBzrLocalResource> filesToCommit, String commitMessage, boolean fullCommit, boolean fullRefresh, Option ... options) {
        this(filesToCommit, commitMessage, options);
        this.fullCommit = fullCommit;
        this.fullRefresh = fullRefresh;
    }

    @Override
    public IResource[] execute(IProgressMonitor monitor) throws BazaarException {
        Map<IBzrBranch, List<File>> map = CommitCommand.getFilesByBranchMap(this.resources);
        try {
            monitor.beginTask(CoreTexts.CommitCommand_commit, this.resources.size());
            monitor.setTaskName(CoreTexts.CommitCommand_commit);
            for (IBzrBranch branch : map.keySet()) {
                IBazaarClient client = BzrWorkspaceRoot.getClient(branch);
                if (this.fullCommit) {
                    client.commit(new File[]{branch.getFile()}, this.commitMessage, this.getOptions());
                    continue;
                }
                client.commit(map.get(branch).toArray(new File[0]), this.commitMessage, this.getOptions());
            }
            if (this.fullCommit || this.fullRefresh) {
                ArrayList<IProject> projects = new ArrayList<IProject>();
                for (IBzrBranch branch : map.keySet()) {
                    projects.addAll(Arrays.asList(BzrWorkspaceRoot.findProjectsInBranch(branch)));
                }
                IResource[] iResourceArray = (IResource[])projects.toArray(new IProject[0]);
                return iResourceArray;
            }
            monitor.worked(this.resources.size());
            IResource[] iResourceArray = CommitCommand.getIResources(this.resources);
            return iResourceArray;
        }
        catch (BazaarClientException e) {
            throw BazaarException.wrapException(e);
        }
        finally {
            monitor.done();
        }
    }
}

