/*
 * Decompiled with CFR 0.152.
 */
package org.vcs.bazaar.eclipse.core.commands;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.vcs.bazaar.client.IBazaarClient;
import org.vcs.bazaar.client.IBazaarConflict;
import org.vcs.bazaar.client.core.BazaarClientException;
import org.vcs.bazaar.eclipse.core.commands.BazaarCommand;
import org.vcs.bazaar.eclipse.core.model.IBzrBranch;
import org.vcs.bazaar.eclipse.internal.core.BazaarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictsCommand
extends BazaarCommand {
    private IBzrBranch branch;
    private List<IBazaarConflict> conflicts;

    public ConflictsCommand(IBzrBranch branch) {
        this.branch = branch;
    }

    @Override
    public void run(IProgressMonitor monitor) throws BazaarException {
        try {
            try {
                monitor.beginTask("Getting conflicts", 1000);
                IBazaarClient client = ConflictsCommand.getClient(this.branch, true);
                this.conflicts = client.conflicts(this.getOptions());
                monitor.worked(1000);
            }
            catch (BazaarClientException e) {
                throw BazaarException.wrapException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    public List<IBazaarConflict> getConflicts() {
        return this.conflicts;
    }
}

